"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildApplication = exports.buildApplicationInternal = void 0;
const architect_1 = require("@angular-devkit/architect");
const purge_cache_1 = require("../../utils/purge-cache");
const version_1 = require("../../utils/version");
const build_action_1 = require("./build-action");
const execute_build_1 = require("./execute-build");
const options_1 = require("./options");
async function* buildApplicationInternal(options, context, infrastructureSettings) {
    // Check Angular version.
    (0, version_1.assertCompatibleAngularVersion)(context.workspaceRoot);
    // Purge old build disk cache.
    await (0, purge_cache_1.purgeStaleBuildCache)(context);
    // Determine project name from builder context target
    const projectName = context.target?.project;
    if (!projectName) {
        context.logger.error(`The 'application' builder requires a target to be specified.`);
        return;
    }
    const normalizedOptions = await (0, options_1.normalizeOptions)(context, projectName, options);
    yield* (0, build_action_1.runEsBuildBuildAction)((rebuildState) => (0, execute_build_1.executeBuild)(normalizedOptions, context, rebuildState), {
        watch: normalizedOptions.watch,
        poll: normalizedOptions.poll,
        deleteOutputPath: normalizedOptions.deleteOutputPath,
        cacheOptions: normalizedOptions.cacheOptions,
        outputPath: normalizedOptions.outputPath,
        verbose: normalizedOptions.verbose,
        projectRoot: normalizedOptions.projectRoot,
        workspaceRoot: normalizedOptions.workspaceRoot,
        progress: normalizedOptions.progress,
        writeToFileSystem: infrastructureSettings?.write,
        logger: context.logger,
    });
}
exports.buildApplicationInternal = buildApplicationInternal;
function buildApplication(options, context) {
    context.logger.warn('The application builder is currently in developer preview and is not yet recommended for production use.');
    return buildApplicationInternal(options, context);
}
exports.buildApplication = buildApplication;
exports.default = (0, architect_1.createBuilder)(buildApplication);
//# sourceMappingURL=data:application/json;base64,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