"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileBuffer = exports.fileBufferToString = exports.stringToFileBuffer = void 0;
const node_util_1 = require("node:util");
function stringToFileBuffer(str) {
    return new node_util_1.TextEncoder().encode(str).buffer;
}
exports.stringToFileBuffer = stringToFileBuffer;
function fileBufferToString(fileBuffer) {
    if (fileBuffer.toString.length === 1) {
        return fileBuffer.toString('utf-8');
    }
    return new node_util_1.TextDecoder('utf-8').decode(new Uint8Array(fileBuffer));
}
exports.fileBufferToString = fileBufferToString;
/** @deprecated use `stringToFileBuffer` instead. */
const fileBuffer = (strings, ...values) => {
    return stringToFileBuffer(String.raw(strings, ...values));
};
exports.fileBuffer = fileBuffer;
//# sourceMappingURL=data:application/json;base64,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