"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeSymbol = exports.FileVisitorCancelToken = exports.MergeStrategy = void 0;
var MergeStrategy;
(function (MergeStrategy) {
    MergeStrategy[MergeStrategy["AllowOverwriteConflict"] = 2] = "AllowOverwriteConflict";
    MergeStrategy[MergeStrategy["AllowCreationConflict"] = 4] = "AllowCreationConflict";
    MergeStrategy[MergeStrategy["AllowDeleteConflict"] = 8] = "AllowDeleteConflict";
    // Uses the default strategy.
    MergeStrategy[MergeStrategy["Default"] = 0] = "Default";
    // Error out if 2 files have the same path. It is useful to have a different value than
    // Default in this case as the tooling Default might differ.
    MergeStrategy[MergeStrategy["Error"] = 1] = "Error";
    // Only content conflicts are overwritten.
    MergeStrategy[MergeStrategy["ContentOnly"] = 2] = "ContentOnly";
    // Overwrite everything with the latest change.
    MergeStrategy[MergeStrategy["Overwrite"] = 14] = "Overwrite";
})(MergeStrategy || (exports.MergeStrategy = MergeStrategy = {}));
// eslint-disable-next-line @typescript-eslint/no-inferrable-types
exports.FileVisitorCancelToken = Symbol();
exports.TreeSymbol = (function () {
    const globalSymbol = (typeof window == 'object' && window.window === window && window.Symbol) ||
        (typeof self == 'object' && self.self === self && self.Symbol) ||
        (typeof global == 'object' && global.global === global && global.Symbol);
    if (!globalSymbol) {
        return Symbol('schematic-tree');
    }
    if (!globalSymbol.schematicTree) {
        globalSymbol.schematicTree = Symbol('schematic-tree');
    }
    return globalSymbol.schematicTree;
})();
// eslint-disable-next-line @typescript-eslint/no-namespace
var Tree;
(function (Tree) {
    function isTree(maybeTree) {
        return exports.TreeSymbol in maybeTree;
    }
    Tree.isTree = isTree;
})(Tree || (Tree = {}));
//# sourceMappingURL=data:application/json;base64,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