declare const _default: {
    configs: {
        all: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/template/alt-text": string;
                "@angular-eslint/template/attributes-order": string;
                "@angular-eslint/template/banana-in-box": string;
                "@angular-eslint/template/button-has-type": string;
                "@angular-eslint/template/click-events-have-key-events": string;
                "@angular-eslint/template/conditional-complexity": string;
                "@angular-eslint/template/cyclomatic-complexity": string;
                "@angular-eslint/template/elements-content": string;
                "@angular-eslint/template/eqeqeq": string;
                "@angular-eslint/template/i18n": string;
                "@angular-eslint/template/interactive-supports-focus": string;
                "@angular-eslint/template/label-has-associated-control": string;
                "@angular-eslint/template/mouse-events-have-key-events": string;
                "@angular-eslint/template/no-any": string;
                "@angular-eslint/template/no-autofocus": string;
                "@angular-eslint/template/no-call-expression": string;
                "@angular-eslint/template/no-distracting-elements": string;
                "@angular-eslint/template/no-duplicate-attributes": string;
                "@angular-eslint/template/no-inline-styles": string;
                "@angular-eslint/template/no-interpolation-in-attributes": string;
                "@angular-eslint/template/no-negated-async": string;
                "@angular-eslint/template/no-positive-tabindex": string;
                "@angular-eslint/template/prefer-ngsrc": string;
                "@angular-eslint/template/prefer-self-closing-tags": string;
                "@angular-eslint/template/role-has-required-aria": string;
                "@angular-eslint/template/table-scope": string;
                "@angular-eslint/template/use-track-by-function": string;
                "@angular-eslint/template/valid-aria": string;
            };
        };
        recommended: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/template/banana-in-box": string;
                "@angular-eslint/template/eqeqeq": string;
                "@angular-eslint/template/no-negated-async": string;
            };
        };
        accessibility: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/template/alt-text": string;
                "@angular-eslint/template/click-events-have-key-events": string;
                "@angular-eslint/template/elements-content": string;
                "@angular-eslint/template/interactive-supports-focus": string;
                "@angular-eslint/template/label-has-associated-control": string;
                "@angular-eslint/template/mouse-events-have-key-events": string;
                "@angular-eslint/template/no-autofocus": string;
                "@angular-eslint/template/no-distracting-elements": string;
                "@angular-eslint/template/role-has-required-aria": string;
                "@angular-eslint/template/table-scope": string;
                "@angular-eslint/template/valid-aria": string;
            };
        };
        'process-inline-templates': {
            parser: string;
            parserOptions: {
                ecmaVersion: number;
                sourceType: string;
            };
            plugins: string[];
            processor: string;
        };
    };
    processors: {
        'extract-inline-html': {
            preprocess: typeof import("./processors").preprocessComponentFile;
            postprocess: typeof import("./processors").postprocessComponentFile;
            supportsAutofix: boolean;
        };
    };
    rules: {
        "alt-text": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"altText", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "attributes-order": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"attributesOrder", [{
            readonly alphabetical: boolean;
            readonly order: readonly import("./rules/attributes-order").OrderType[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "banana-in-box": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"bananaInBox", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "button-has-type": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/button-has-type").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "click-events-have-key-events": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"clickEventsHaveKeyEvents", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "conditional-complexity": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"conditionalComplexity", [{
            maxComplexity: number;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "cyclomatic-complexity": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"cyclomaticComplexity", [{
            maxComplexity: number;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "elements-content": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"elementsContent", [{
            readonly allowList?: readonly string[] | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        eqeqeq: import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/eqeqeq").MessageIds, [{
            readonly allowNullOrUndefined?: boolean | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        i18n: import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/i18n").MessageIds, [{
            readonly boundTextAllowedPattern?: string | undefined;
            readonly checkAttributes?: boolean | undefined;
            readonly checkDuplicateId?: boolean | undefined;
            readonly checkId?: boolean | undefined;
            readonly checkText?: boolean | undefined;
            readonly ignoreAttributes?: readonly string[] | undefined;
            readonly ignoreTags?: readonly string[] | undefined;
            readonly requireDescription?: boolean | undefined;
            readonly requireMeaning?: boolean | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "interactive-supports-focus": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"interactiveSupportsFocus", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "label-has-associated-control": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"labelHasAssociatedControl", [{
            readonly controlComponents?: readonly string[] | undefined;
            readonly labelComponents?: readonly {
                readonly inputs?: readonly string[] | undefined;
                readonly selector: string;
            }[] | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "mouse-events-have-key-events": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"mouseEventsHaveKeyEvents", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-any": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-any").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-autofocus": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noAutofocus", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-call-expression": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noCallExpression", [{
            readonly allowList?: readonly string[] | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-distracting-elements": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noDistractingElements", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-duplicate-attributes": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-duplicate-attributes").MessageIds, [{
            readonly allowTwoWayDataBinding?: boolean | undefined;
            readonly allowStylePrecedenceDuplicates?: boolean | undefined;
            readonly ignore?: readonly string[] | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-inline-styles": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noInlineStyles", [{
            readonly allowNgStyle?: boolean | undefined;
            readonly allowBindToStyle?: boolean | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-interpolation-in-attributes": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noInterpolationInAttributes", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-negated-async": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-negated-async").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-positive-tabindex": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-positive-tabindex").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "prefer-self-closing-tags": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"preferSelfClosingTags", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "prefer-ngsrc": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/prefer-ngsrc").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "role-has-required-aria": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/role-has-required-aria").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "table-scope": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"tableScope", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-track-by-function": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"useTrackByFunction", [{
            readonly alias: readonly string[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "valid-aria": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/valid-aria").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
    };
};
export = _default;
