declare const _default: {
    configs: {
        all: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/component-class-suffix": string;
                "@angular-eslint/component-max-inline-declarations": string;
                "@angular-eslint/component-selector": string;
                "@angular-eslint/contextual-decorator": string;
                "@angular-eslint/contextual-lifecycle": string;
                "@angular-eslint/directive-class-suffix": string;
                "@angular-eslint/directive-selector": string;
                "@angular-eslint/no-attribute-decorator": string;
                "@angular-eslint/no-conflicting-lifecycle": string;
                "@angular-eslint/no-empty-lifecycle-method": string;
                "@angular-eslint/no-forward-ref": string;
                "@angular-eslint/no-host-metadata-property": string;
                "@angular-eslint/no-input-prefix": string;
                "@angular-eslint/no-input-rename": string;
                "@angular-eslint/no-inputs-metadata-property": string;
                "@angular-eslint/no-lifecycle-call": string;
                "@angular-eslint/no-output-native": string;
                "@angular-eslint/no-output-on-prefix": string;
                "@angular-eslint/no-output-rename": string;
                "@angular-eslint/no-outputs-metadata-property": string;
                "@angular-eslint/no-pipe-impure": string;
                "@angular-eslint/no-queries-metadata-property": string;
                "@angular-eslint/pipe-prefix": string;
                "@angular-eslint/prefer-on-push-component-change-detection": string;
                "@angular-eslint/prefer-output-readonly": string;
                "@angular-eslint/prefer-standalone-component": string;
                "@angular-eslint/relative-url-prefix": string;
                "@angular-eslint/require-localize-metadata": string;
                "@angular-eslint/sort-lifecycle-methods": string;
                "@angular-eslint/sort-ngmodule-metadata-arrays": string;
                "@angular-eslint/use-component-selector": string;
                "@angular-eslint/use-component-view-encapsulation": string;
                "@angular-eslint/use-injectable-provided-in": string;
                "@angular-eslint/use-lifecycle-interface": string;
                "@angular-eslint/use-pipe-transform-interface": string;
            };
        };
        recommended: {
            parser: string;
            plugins: string[];
            rules: {
                "@angular-eslint/component-class-suffix": string;
                "@angular-eslint/contextual-lifecycle": string;
                "@angular-eslint/directive-class-suffix": string;
                "@angular-eslint/no-empty-lifecycle-method": string;
                "@angular-eslint/no-host-metadata-property": string;
                "@angular-eslint/no-input-rename": string;
                "@angular-eslint/no-inputs-metadata-property": string;
                "@angular-eslint/no-output-native": string;
                "@angular-eslint/no-output-on-prefix": string;
                "@angular-eslint/no-output-rename": string;
                "@angular-eslint/no-outputs-metadata-property": string;
                "@angular-eslint/use-lifecycle-interface": string;
                "@angular-eslint/use-pipe-transform-interface": string;
            };
        };
    };
    rules: {
        "component-class-suffix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"componentClassSuffix", [{
            suffixes: string[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "component-max-inline-declarations": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"componentMaxInlineDeclarations", [{
            readonly template?: number | undefined;
            readonly styles?: number | undefined;
            readonly animations?: number | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "component-selector": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/component-selector").MessageIds, import("@angular-eslint/utils/dist/eslint-plugin/selector-utils").Options, import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "contextual-decorator": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"contextualDecorator", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "contextual-lifecycle": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"contextualLifecycle", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "directive-class-suffix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"directiveClassSuffix", [{
            readonly suffixes: readonly string[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "directive-selector": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/directive-selector").MessageIds, import("@angular-eslint/utils/dist/eslint-plugin/selector-utils").Options, import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-attribute-decorator": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noAttributeDecorator", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-conflicting-lifecycle": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-conflicting-lifecycle").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-empty-lifecycle-method": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-empty-lifecycle-method").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-forward-ref": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noForwardRef", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-host-metadata-property": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noHostMetadataProperty", [{
            readonly allowStatic?: boolean | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-input-prefix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noInputPrefix", [{
            readonly prefixes: readonly string[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-input-rename": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-input-rename").MessageIds, [{
            readonly allowedNames?: readonly string[] | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-inputs-metadata-property": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noInputsMetadataProperty", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-lifecycle-call": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noLifecycleCall", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-output-native": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noOutputNative", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-output-on-prefix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noOutputOnPrefix", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-output-rename": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-output-rename").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-outputs-metadata-property": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noOutputsMetadataProperty", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-pipe-impure": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/no-pipe-impure").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "no-queries-metadata-property": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"noQueriesMetadataProperty", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "pipe-prefix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"pipePrefix", [{
            prefixes: string[];
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "prefer-on-push-component-change-detection": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/prefer-on-push-component-change-detection").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "prefer-standalone-component": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"preferStandaloneComponent", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "prefer-output-readonly": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/prefer-output-readonly").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "relative-url-prefix": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"relativeUrlPrefix", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "require-localize-metadata": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/require-localize-metadata").MessageIds, [{
            readonly requireDescription?: boolean | undefined;
            readonly requireMeaning?: boolean | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "sort-lifecycle-methods": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"lifecycleMethodsNotSorted", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "sort-ngmodule-metadata-arrays": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"sortNgmoduleMetadataArrays", [{
            readonly locale: string;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-component-selector": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"useComponentSelector", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-component-view-encapsulation": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/use-component-view-encapsulation").MessageIds, [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-injectable-provided-in": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<import("./rules/use-injectable-provided-in").MessageIds, [{
            readonly ignoreClassNamePattern?: string | undefined;
        }], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-lifecycle-interface": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"useLifecycleInterface", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
        "use-pipe-transform-interface": import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleModule<"usePipeTransformInterface", [], import("@typescript-eslint/utils/dist/ts-eslint/Rule").RuleListener>;
    };
};
export = _default;
