"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RULE_NAME = void 0;
const utils_1 = require("@angular-eslint/utils");
const create_eslint_rule_1 = require("../utils/create-eslint-rule");
exports.RULE_NAME = 'prefer-standalone-component';
const METADATA_PROPERTY_NAME = 'standalone';
const IS_STANDALONE = 'true';
exports.default = (0, create_eslint_rule_1.createESLintRule)({
    name: exports.RULE_NAME,
    meta: {
        type: 'suggestion',
        docs: {
            description: `Ensures component \`${METADATA_PROPERTY_NAME}\` property is set to \`${IS_STANDALONE}\` in the component decorator`,
            recommended: false,
        },
        fixable: 'code',
        schema: [],
        messages: {
            preferStandaloneComponent: `The component \`${METADATA_PROPERTY_NAME}\` property should be set to \`${IS_STANDALONE}\``,
        },
    },
    defaultOptions: [],
    create(context) {
        return {
            [utils_1.Selectors.COMPONENT_CLASS_DECORATOR](node) {
                const standalone = utils_1.ASTUtils.getDecoratorPropertyValue(node, METADATA_PROPERTY_NAME);
                if (standalone &&
                    utils_1.ASTUtils.isLiteral(standalone) &&
                    standalone.value === true) {
                    return;
                }
                context.report({
                    node: nodeToReport(node),
                    messageId: 'preferStandaloneComponent',
                    fix: (fixer) => {
                        if (standalone &&
                            utils_1.ASTUtils.isLiteral(standalone) &&
                            standalone.value !== true) {
                            return [fixer.replaceText(standalone, IS_STANDALONE)].filter(utils_1.isNotNullOrUndefined);
                        }
                        return [
                            utils_1.RuleFixes.getDecoratorPropertyAddFix(node, fixer, `${METADATA_PROPERTY_NAME}: ${IS_STANDALONE}`),
                        ].filter(utils_1.isNotNullOrUndefined);
                    },
                });
            },
        };
    },
});
function nodeToReport(node) {
    if (!utils_1.ASTUtils.isProperty(node)) {
        return node;
    }
    return utils_1.ASTUtils.isMemberExpression(node.value)
        ? node.value.property
        : node.value;
}
