"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const devkit_1 = require("@nx/devkit");
const utils_1 = require("../utils");
exports.default = (0, devkit_1.convertNxGenerator)(async (tree, options) => {
    var _a;
    const projectName = (0, utils_1.determineTargetProjectName__NX)(tree, options.project);
    if (!projectName) {
        throw new Error('\n' +
            `
Error: You must specify a project to add ESLint to because you have multiple projects in your angular.json

E.g. npx ng g @angular-eslint/schematics:add-eslint-to-project {{YOUR_PROJECT_NAME_GOES_HERE}}
      `.trim());
    }
    // Update the lint builder and config in angular.json
    (0, utils_1.addESLintTargetToProject__NX)(tree, projectName, 'lint');
    (0, utils_1.createESLintConfigForProject__NX)(tree, projectName, (_a = options.setParserOptionsProject) !== null && _a !== void 0 ? _a : false);
});
