/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpContext, HttpContextToken } from './src/context';
export { FetchBackend } from './src/fetch';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS, HttpInterceptorHandler as ɵHttpInterceptorHandler, HttpInterceptorHandler as ɵHttpInterceptingHandler } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpFeatureKind, provideHttpClient, withFetch, withInterceptors, withInterceptorsFromDi, withJsonpSupport, withNoXsrfProtection, withRequestsMadeViaParent, withXsrfConfiguration } from './src/provider';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { withHttpTransferCache as ɵwithHttpTransferCache } from './src/transfer_cache';
export { HttpXhrBackend } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
//# sourceMappingURL=data:application/json;base64,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