/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Marker symbol for `ConsumesSlotOpTrait`.
 */
export const ConsumesSlot = Symbol('ConsumesSlot');
/**
 * Marker symbol for `DependsOnSlotContextOpTrait`.
 */
export const DependsOnSlotContext = Symbol('DependsOnSlotContext');
/**
 * Marker symbol for `UsesSlotIndex` trait.
 */
export const UsesSlotIndex = Symbol('UsesSlotIndex');
/**
 * Marker symbol for `ConsumesVars` trait.
 */
export const ConsumesVarsTrait = Symbol('ConsumesVars');
/**
 * Marker symbol for `UsesVarOffset` trait.
 */
export const UsesVarOffset = Symbol('UsesVarOffset');
/**
 * Default values for most `ConsumesSlotOpTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_SLOT = {
    [ConsumesSlot]: true,
    slot: null,
    numSlotsUsed: 1,
};
/**
 * Default values for most `UsesSlotIndexTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_USES_SLOT_INDEX = {
    [UsesSlotIndex]: true,
    slot: null,
};
/**
 * Default values for most `DependsOnSlotContextOpTrait` fields (used with the spread operator to
 * initialize implementors of the trait).
 */
export const TRAIT_DEPENDS_ON_SLOT_CONTEXT = {
    [DependsOnSlotContext]: true,
};
/**
 * Default values for `UsesVars` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_VARS = {
    [ConsumesVarsTrait]: true,
};
/**
 * Default values for `UsesVarOffset` fields (used with the spread operator to initialize
 * implementors of this trait).
 */
export const TRAIT_USES_VAR_OFFSET = {
    [UsesVarOffset]: true,
    varOffset: null,
};
/**
 * Test whether an operation implements `ConsumesSlotOpTrait`.
 */
export function hasConsumesSlotTrait(op) {
    return op[ConsumesSlot] === true;
}
/**
 * Test whether an operation implements `DependsOnSlotContextOpTrait`.
 */
export function hasDependsOnSlotContextTrait(op) {
    return op[DependsOnSlotContext] === true;
}
export function hasConsumesVarsTrait(value) {
    return value[ConsumesVarsTrait] === true;
}
/**
 * Test whether an expression implements `UsesVarOffsetTrait`.
 */
export function hasUsesVarOffsetTrait(expr) {
    return expr[UsesVarOffset] === true;
}
export function hasUsesSlotIndexTrait(value) {
    return value[UsesSlotIndex] === true;
}
//# sourceMappingURL=data:application/json;base64,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