/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as o from '../../../output/output_ast';
import * as ir from '../ir';
export const BINARY_OPERATORS = new Map([
    ['&&', o.BinaryOperator.And],
    ['>', o.BinaryOperator.Bigger],
    ['>=', o.BinaryOperator.BiggerEquals],
    ['&', o.BinaryOperator.BitwiseAnd],
    ['/', o.BinaryOperator.Divide],
    ['==', o.BinaryOperator.Equals],
    ['===', o.BinaryOperator.Identical],
    ['<', o.BinaryOperator.Lower],
    ['<=', o.BinaryOperator.LowerEquals],
    ['-', o.BinaryOperator.Minus],
    ['%', o.BinaryOperator.Modulo],
    ['*', o.BinaryOperator.Multiply],
    ['!=', o.BinaryOperator.NotEquals],
    ['!==', o.BinaryOperator.NotIdentical],
    ['??', o.BinaryOperator.NullishCoalesce],
    ['||', o.BinaryOperator.Or],
    ['+', o.BinaryOperator.Plus],
]);
export const NAMESPACES = new Map([['svg', ir.Namespace.SVG], ['math', ir.Namespace.Math]]);
export function namespaceForKey(namespacePrefixKey) {
    if (namespacePrefixKey === null) {
        return ir.Namespace.HTML;
    }
    return NAMESPACES.get(namespacePrefixKey) ?? ir.Namespace.HTML;
}
export function keyForNamespace(namespace) {
    for (const [k, n] of NAMESPACES.entries()) {
        if (n === namespace) {
            return k;
        }
    }
    return null; // No namespace prefix for HTML
}
export function prefixWithNamespace(strippedTag, namespace) {
    if (namespace === ir.Namespace.HTML) {
        return strippedTag;
    }
    return `:${keyForNamespace(namespace)}:${strippedTag}`;
}
//# sourceMappingURL=data:application/json;base64,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