/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/*
 * This file re-exports all symbols contained in this directory.
 *
 * Why is this file not `index.ts`?
 *
 * There seems to be an inconsistent path resolution of an `index.ts` file
 * when only the parent directory is referenced. This could be due to the
 * node module resolution configuration differing from rollup and/or typescript.
 *
 * With commit
 * https://github.com/angular/angular/commit/d5e3f2c64bd13ce83e7c70788b7fc514ca4a9918
 * the `instructions.ts` file was moved to `instructions/instructions.ts` and an
 * `index.ts` file was used to re-export everything. Having had file names that were
 * importing from `instructions' directly (not the from the sub file or the `index.ts`
 * file) caused strange CI issues. `index.ts` had to be renamed to `all.ts` for this
 * to work.
 *
 * Jira Issue = FW-1184
 */
export * from './attribute';
export * from './attribute_interpolation';
export * from './change_detection';
export * from './template';
export * from './storage';
export * from './di';
export * from './di_attr';
export * from './element';
export * from './element_container';
export * from './get_current_view';
export * from './listener';
export * from './namespace';
export * from './next_context';
export * from './projection';
export * from './property';
export * from './property_interpolation';
export * from './advance';
export * from './styling';
export * from './text';
export * from './text_interpolation';
export * from './class_map_interpolation';
export * from './style_map_interpolation';
export * from './style_prop_interpolation';
export * from './host_property';
export * from './i18n';
export * from './defer';
export { ɵgetUnknownElementStrictMode, ɵsetUnknownElementStrictMode, ɵgetUnknownPropertyStrictMode, ɵsetUnknownPropertyStrictMode } from './element_validation';
//# sourceMappingURL=data:application/json;base64,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