/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Below are constants for LView indices to help us look up LView members
// without having to remember the specific indices.
// Uglify will inline these when minifying so there shouldn't be a cost.
export const HOST = 0;
export const TVIEW = 1;
export const FLAGS = 2;
export const PARENT = 3;
export const NEXT = 4;
export const DESCENDANT_VIEWS_TO_REFRESH = 5;
export const T_HOST = 6;
export const CLEANUP = 7;
export const CONTEXT = 8;
export const INJECTOR = 9;
export const ENVIRONMENT = 10;
export const RENDERER = 11;
export const CHILD_HEAD = 12;
export const CHILD_TAIL = 13;
// FIXME(misko): Investigate if the three declarations aren't all same thing.
export const DECLARATION_VIEW = 14;
export const DECLARATION_COMPONENT_VIEW = 15;
export const DECLARATION_LCONTAINER = 16;
export const PREORDER_HOOK_FLAGS = 17;
export const QUERIES = 18;
export const ID = 19;
export const EMBEDDED_VIEW_INJECTOR = 20;
export const ON_DESTROY_HOOKS = 21;
export const HYDRATION = 22;
export const REACTIVE_TEMPLATE_CONSUMER = 23;
export const REACTIVE_HOST_BINDING_CONSUMER = 24;
/**
 * Size of LView's header. Necessary to adjust for it when setting slots.
 *
 * IMPORTANT: `HEADER_OFFSET` should only be referred to the in the `ɵɵ*` instructions to translate
 * instruction index into `LView` index. All other indexes should be in the `LView` index space and
 * there should be no need to refer to `HEADER_OFFSET` anywhere else.
 */
export const HEADER_OFFSET = 25;
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
export const unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlldy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL3JlbmRlcjMvaW50ZXJmYWNlcy92aWV3LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQXNCSCx5RUFBeUU7QUFDekUsbURBQW1EO0FBQ25ELHdFQUF3RTtBQUN4RSxNQUFNLENBQUMsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO0FBQ3RCLE1BQU0sQ0FBQyxNQUFNLEtBQUssR0FBRyxDQUFDLENBQUM7QUFDdkIsTUFBTSxDQUFDLE1BQU0sS0FBSyxHQUFHLENBQUMsQ0FBQztBQUN2QixNQUFNLENBQUMsTUFBTSxNQUFNLEdBQUcsQ0FBQyxDQUFDO0FBQ3hCLE1BQU0sQ0FBQyxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7QUFDdEIsTUFBTSxDQUFDLE1BQU0sMkJBQTJCLEdBQUcsQ0FBQyxDQUFDO0FBQzdDLE1BQU0sQ0FBQyxNQUFNLE1BQU0sR0FBRyxDQUFDLENBQUM7QUFDeEIsTUFBTSxDQUFDLE1BQU0sT0FBTyxHQUFHLENBQUMsQ0FBQztBQUN6QixNQUFNLENBQUMsTUFBTSxPQUFPLEdBQUcsQ0FBQyxDQUFDO0FBQ3pCLE1BQU0sQ0FBQyxNQUFNLFFBQVEsR0FBRyxDQUFDLENBQUM7QUFDMUIsTUFBTSxDQUFDLE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQztBQUM5QixNQUFNLENBQUMsTUFBTSxRQUFRLEdBQUcsRUFBRSxDQUFDO0FBQzNCLE1BQU0sQ0FBQyxNQUFNLFVBQVUsR0FBRyxFQUFFLENBQUM7QUFDN0IsTUFBTSxDQUFDLE1BQU0sVUFBVSxHQUFHLEVBQUUsQ0FBQztBQUM3Qiw2RUFBNkU7QUFDN0UsTUFBTSxDQUFDLE1BQU0sZ0JBQWdCLEdBQUcsRUFBRSxDQUFDO0FBQ25DLE1BQU0sQ0FBQyxNQUFNLDBCQUEwQixHQUFHLEVBQUUsQ0FBQztBQUM3QyxNQUFNLENBQUMsTUFBTSxzQkFBc0IsR0FBRyxFQUFFLENBQUM7QUFDekMsTUFBTSxDQUFDLE1BQU0sbUJBQW1CLEdBQUcsRUFBRSxDQUFDO0FBQ3RDLE1BQU0sQ0FBQyxNQUFNLE9BQU8sR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxDQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQztBQUNyQixNQUFNLENBQUMsTUFBTSxzQkFBc0IsR0FBRyxFQUFFLENBQUM7QUFDekMsTUFBTSxDQUFDLE1BQU0sZ0JBQWdCLEdBQUcsRUFBRSxDQUFDO0FBQ25DLE1BQU0sQ0FBQyxNQUFNLFNBQVMsR0FBRyxFQUFFLENBQUM7QUFDNUIsTUFBTSxDQUFDLE1BQU0sMEJBQTBCLEdBQUcsRUFBRSxDQUFDO0FBQzdDLE1BQU0sQ0FBQyxNQUFNLDhCQUE4QixHQUFHLEVBQUUsQ0FBQztBQUNqRDs7Ozs7O0dBTUc7QUFDSCxNQUFNLENBQUMsTUFBTSxhQUFhLEdBQUcsRUFBRSxDQUFDO0FBazFCaEMsaUZBQWlGO0FBQ2pGLDBCQUEwQjtBQUMxQixNQUFNLENBQUMsTUFBTSw2QkFBNkIsR0FBRyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtJbmplY3Rvcn0gZnJvbSAnLi4vLi4vZGkvaW5qZWN0b3InO1xuaW1wb3J0IHtQcm92aWRlclRva2VufSBmcm9tICcuLi8uLi9kaS9wcm92aWRlcl90b2tlbic7XG5pbXBvcnQge0RlaHlkcmF0ZWRWaWV3fSBmcm9tICcuLi8uLi9oeWRyYXRpb24vaW50ZXJmYWNlcyc7XG5pbXBvcnQge1NjaGVtYU1ldGFkYXRhfSBmcm9tICcuLi8uLi9tZXRhZGF0YS9zY2hlbWEnO1xuaW1wb3J0IHtTYW5pdGl6ZXJ9IGZyb20gJy4uLy4uL3Nhbml0aXphdGlvbi9zYW5pdGl6ZXInO1xuaW1wb3J0IHR5cGUge1JlYWN0aXZlTFZpZXdDb25zdW1lcn0gZnJvbSAnLi4vcmVhY3RpdmVfbHZpZXdfY29uc3VtZXInO1xuaW1wb3J0IHR5cGUge0VmZmVjdE1hbmFnZXJ9IGZyb20gJy4uL3JlYWN0aXZpdHkvZWZmZWN0JztcbmltcG9ydCB0eXBlIHtBZnRlclJlbmRlckV2ZW50TWFuYWdlcn0gZnJvbSAnLi4vYWZ0ZXJfcmVuZGVyX2hvb2tzJztcblxuaW1wb3J0IHtMQ29udGFpbmVyfSBmcm9tICcuL2NvbnRhaW5lcic7XG5pbXBvcnQge0NvbXBvbmVudERlZiwgQ29tcG9uZW50VGVtcGxhdGUsIERpcmVjdGl2ZURlZiwgRGlyZWN0aXZlRGVmTGlzdCwgSG9zdEJpbmRpbmdzRnVuY3Rpb24sIFBpcGVEZWYsIFBpcGVEZWZMaXN0LCBWaWV3UXVlcmllc0Z1bmN0aW9ufSBmcm9tICcuL2RlZmluaXRpb24nO1xuaW1wb3J0IHtJMThuVXBkYXRlT3BDb2RlcywgVEkxOG4sIFRJY3V9IGZyb20gJy4vaTE4bic7XG5pbXBvcnQge1RDb25zdGFudHMsIFROb2RlfSBmcm9tICcuL25vZGUnO1xuaW1wb3J0IHtMUXVlcmllcywgVFF1ZXJpZXN9IGZyb20gJy4vcXVlcnknO1xuaW1wb3J0IHtSZW5kZXJlciwgUmVuZGVyZXJGYWN0b3J5fSBmcm9tICcuL3JlbmRlcmVyJztcbmltcG9ydCB7UkVsZW1lbnR9IGZyb20gJy4vcmVuZGVyZXJfZG9tJztcbmltcG9ydCB7VFN0eWxpbmdLZXksIFRTdHlsaW5nUmFuZ2V9IGZyb20gJy4vc3R5bGluZyc7XG5cblxuXG4vLyBCZWxvdyBhcmUgY29uc3RhbnRzIGZvciBMVmlldyBpbmRpY2VzIHRvIGhlbHAgdXMgbG9vayB1cCBMVmlldyBtZW1iZXJzXG4vLyB3aXRob3V0IGhhdmluZyB0byByZW1lbWJlciB0aGUgc3BlY2lmaWMgaW5kaWNlcy5cbi8vIFVnbGlmeSB3aWxsIGlubGluZSB0aGVzZSB3aGVuIG1pbmlmeWluZyBzbyB0aGVyZSBzaG91bGRuJ3QgYmUgYSBjb3N0LlxuZXhwb3J0IGNvbnN0IEhPU1QgPSAwO1xuZXhwb3J0IGNvbnN0IFRWSUVXID0gMTtcbmV4cG9ydCBjb25zdCBGTEFHUyA9IDI7XG5leHBvcnQgY29uc3QgUEFSRU5UID0gMztcbmV4cG9ydCBjb25zdCBORVhUID0gNDtcbmV4cG9ydCBjb25zdCBERVNDRU5EQU5UX1ZJRVdTX1RPX1JFRlJFU0ggPSA1O1xuZXhwb3J0IGNvbnN0IFRfSE9TVCA9IDY7XG5leHBvcnQgY29uc3QgQ0xFQU5VUCA9IDc7XG5leHBvcnQgY29uc3QgQ09OVEVYVCA9IDg7XG5leHBvcnQgY29uc3QgSU5KRUNUT1IgPSA5O1xuZXhwb3J0IGNvbnN0IEVOVklST05NRU5UID0gMTA7XG5leHBvcnQgY29uc3QgUkVOREVSRVIgPSAxMTtcbmV4cG9ydCBjb25zdCBDSElMRF9IRUFEID0gMTI7XG5leHBvcnQgY29uc3QgQ0hJTERfVEFJTCA9IDEzO1xuLy8gRklYTUUobWlza28pOiBJbnZlc3RpZ2F0ZSBpZiB0aGUgdGhyZWUgZGVjbGFyYXRpb25zIGFyZW4ndCBhbGwgc2FtZSB0aGluZy5cbmV4cG9ydCBjb25zdCBERUNMQVJBVElPTl9WSUVXID0gMTQ7XG5leHBvcnQgY29uc3QgREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVcgPSAxNTtcbmV4cG9ydCBjb25zdCBERUNMQVJBVElPTl9MQ09OVEFJTkVSID0gMTY7XG5leHBvcnQgY29uc3QgUFJFT1JERVJfSE9PS19GTEFHUyA9IDE3O1xuZXhwb3J0IGNvbnN0IFFVRVJJRVMgPSAxODtcbmV4cG9ydCBjb25zdCBJRCA9IDE5O1xuZXhwb3J0IGNvbnN0IEVNQkVEREVEX1ZJRVdfSU5KRUNUT1IgPSAyMDtcbmV4cG9ydCBjb25zdCBPTl9ERVNUUk9ZX0hPT0tTID0gMjE7XG5leHBvcnQgY29uc3QgSFlEUkFUSU9OID0gMjI7XG5leHBvcnQgY29uc3QgUkVBQ1RJVkVfVEVNUExBVEVfQ09OU1VNRVIgPSAyMztcbmV4cG9ydCBjb25zdCBSRUFDVElWRV9IT1NUX0JJTkRJTkdfQ09OU1VNRVIgPSAyNDtcbi8qKlxuICogU2l6ZSBvZiBMVmlldydzIGhlYWRlci4gTmVjZXNzYXJ5IHRvIGFkanVzdCBmb3IgaXQgd2hlbiBzZXR0aW5nIHNsb3RzLlxuICpcbiAqIElNUE9SVEFOVDogYEhFQURFUl9PRkZTRVRgIHNob3VsZCBvbmx5IGJlIHJlZmVycmVkIHRvIHRoZSBpbiB0aGUgYMm1ybUqYCBpbnN0cnVjdGlvbnMgdG8gdHJhbnNsYXRlXG4gKiBpbnN0cnVjdGlvbiBpbmRleCBpbnRvIGBMVmlld2AgaW5kZXguIEFsbCBvdGhlciBpbmRleGVzIHNob3VsZCBiZSBpbiB0aGUgYExWaWV3YCBpbmRleCBzcGFjZSBhbmRcbiAqIHRoZXJlIHNob3VsZCBiZSBubyBuZWVkIHRvIHJlZmVyIHRvIGBIRUFERVJfT0ZGU0VUYCBhbnl3aGVyZSBlbHNlLlxuICovXG5leHBvcnQgY29uc3QgSEVBREVSX09GRlNFVCA9IDI1O1xuXG5cbi8vIFRoaXMgaW50ZXJmYWNlIHJlcGxhY2VzIHRoZSByZWFsIExWaWV3IGludGVyZmFjZSBpZiBpdCBpcyBhbiBhcmcgb3IgYVxuLy8gcmV0dXJuIHZhbHVlIG9mIGEgcHVibGljIGluc3RydWN0aW9uLiBUaGlzIGVuc3VyZXMgd2UgZG9uJ3QgbmVlZCB0byBleHBvc2Vcbi8vIHRoZSBhY3R1YWwgaW50ZXJmYWNlLCB3aGljaCBzaG91bGQgYmUga2VwdCBwcml2YXRlLlxuZXhwb3J0IGludGVyZmFjZSBPcGFxdWVWaWV3U3RhdGUge1xuICAnX19icmFuZF9fJzogJ0JyYW5kIGZvciBPcGFxdWVWaWV3U3RhdGUgdGhhdCBub3RoaW5nIHdpbGwgbWF0Y2gnO1xufVxuXG5cbi8qKlxuICogYExWaWV3YCBzdG9yZXMgYWxsIG9mIHRoZSBpbmZvcm1hdGlvbiBuZWVkZWQgdG8gcHJvY2VzcyB0aGUgaW5zdHJ1Y3Rpb25zIGFzXG4gKiB0aGV5IGFyZSBpbnZva2VkIGZyb20gdGhlIHRlbXBsYXRlLiBFYWNoIGVtYmVkZGVkIHZpZXcgYW5kIGNvbXBvbmVudCB2aWV3IGhhcyBpdHNcbiAqIG93biBgTFZpZXdgLiBXaGVuIHByb2Nlc3NpbmcgYSBwYXJ0aWN1bGFyIHZpZXcsIHdlIHNldCB0aGUgYHZpZXdEYXRhYCB0byB0aGF0XG4gKiBgTFZpZXdgLiBXaGVuIHRoYXQgdmlldyBpcyBkb25lIHByb2Nlc3NpbmcsIHRoZSBgdmlld0RhdGFgIGlzIHNldCBiYWNrIHRvXG4gKiB3aGF0ZXZlciB0aGUgb3JpZ2luYWwgYHZpZXdEYXRhYCB3YXMgYmVmb3JlICh0aGUgcGFyZW50IGBMVmlld2ApLlxuICpcbiAqIEtlZXBpbmcgc2VwYXJhdGUgc3RhdGUgZm9yIGVhY2ggdmlldyBmYWNpbGl0aWVzIHZpZXcgaW5zZXJ0aW9uIC8gZGVsZXRpb24sIHNvIHdlXG4gKiBkb24ndCBoYXZlIHRvIGVkaXQgdGhlIGRhdGEgYXJyYXkgYmFzZWQgb24gd2hpY2ggdmlld3MgYXJlIHByZXNlbnQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTFZpZXc8VCA9IHVua25vd24+IGV4dGVuZHMgQXJyYXk8YW55PiB7XG4gIC8qKlxuICAgKiBUaGUgbm9kZSBpbnRvIHdoaWNoIHRoaXMgYExWaWV3YCBpcyBpbnNlcnRlZC5cbiAgICovXG4gIFtIT1NUXTogUkVsZW1lbnR8bnVsbDtcblxuICAvKipcbiAgICogVGhlIHN0YXRpYyBkYXRhIGZvciB0aGlzIHZpZXcuIFdlIG5lZWQgYSByZWZlcmVuY2UgdG8gdGhpcyBzbyB3ZSBjYW4gZWFzaWx5IHdhbGsgdXAgdGhlXG4gICAqIG5vZGUgdHJlZSBpbiBESSBhbmQgZ2V0IHRoZSBUVmlldy5kYXRhIGFycmF5IGFzc29jaWF0ZWQgd2l0aCBhIG5vZGUgKHdoZXJlIHRoZVxuICAgKiBkaXJlY3RpdmUgZGVmcyBhcmUgc3RvcmVkKS5cbiAgICovXG4gIHJlYWRvbmx5W1RWSUVXXTogVFZpZXc7XG5cbiAgLyoqIEZsYWdzIGZvciB0aGlzIHZpZXcuIFNlZSBMVmlld0ZsYWdzIGZvciBtb3JlIGluZm8uICovXG4gIFtGTEFHU106IExWaWV3RmxhZ3M7XG5cbiAgLyoqXG4gICAqIFRoaXMgbWF5IHN0b3JlIGFuIHtAbGluayBMVmlld30gb3Ige0BsaW5rIExDb250YWluZXJ9LlxuICAgKlxuICAgKiBgTFZpZXdgIC0gVGhlIHBhcmVudCB2aWV3LiBUaGlzIGlzIG5lZWRlZCB3aGVuIHdlIGV4aXQgdGhlIHZpZXcgYW5kIG11c3QgcmVzdG9yZSB0aGUgcHJldmlvdXNcbiAgICogTFZpZXcuIFdpdGhvdXQgdGhpcywgdGhlIHJlbmRlciBtZXRob2Qgd291bGQgaGF2ZSB0byBrZWVwIGEgc3RhY2sgb2ZcbiAgICogdmlld3MgYXMgaXQgaXMgcmVjdXJzaXZlbHkgcmVuZGVyaW5nIHRlbXBsYXRlcy5cbiAgICpcbiAgICogYExDb250YWluZXJgIC0gVGhlIGN1cnJlbnQgdmlldyBpcyBwYXJ0IG9mIGEgY29udGFpbmVyLCBhbmQgaXMgYW4gZW1iZWRkZWQgdmlldy5cbiAgICovXG4gIFtQQVJFTlRdOiBMVmlld3xMQ29udGFpbmVyfG51bGw7XG5cbiAgLyoqXG4gICAqXG4gICAqIFRoZSBuZXh0IHNpYmxpbmcgTFZpZXcgb3IgTENvbnRhaW5lci5cbiAgICpcbiAgICogQWxsb3dzIHVzIHRvIHByb3BhZ2F0ZSBiZXR3ZWVuIHNpYmxpbmcgdmlldyBzdGF0ZXMgdGhhdCBhcmVuJ3QgaW4gdGhlIHNhbWVcbiAgICogY29udGFpbmVyLiBFbWJlZGRlZCB2aWV3cyBhbHJlYWR5IGhhdmUgYSBub2RlLm5leHQsIGJ1dCBpdCBpcyBvbmx5IHNldCBmb3JcbiAgICogdmlld3MgaW4gdGhlIHNhbWUgY29udGFpbmVyLiBXZSBuZWVkIGEgd2F5IHRvIGxpbmsgY29tcG9uZW50IHZpZXdzIGFuZCB2aWV3c1xuICAgKiBhY3Jvc3MgY29udGFpbmVycyBhcyB3ZWxsLlxuICAgKi9cbiAgW05FWFRdOiBMVmlld3xMQ29udGFpbmVyfG51bGw7XG5cbiAgLyoqIFF1ZXJpZXMgYWN0aXZlIGZvciB0aGlzIHZpZXcgLSBub2RlcyBmcm9tIGEgdmlldyBhcmUgcmVwb3J0ZWQgdG8gdGhvc2UgcXVlcmllcy4gKi9cbiAgW1FVRVJJRVNdOiBMUXVlcmllc3xudWxsO1xuXG4gIC8qKlxuICAgKiBTdG9yZSB0aGUgYFROb2RlYCBvZiB0aGUgbG9jYXRpb24gd2hlcmUgdGhlIGN1cnJlbnQgYExWaWV3YCBpcyBpbnNlcnRlZCBpbnRvLlxuICAgKlxuICAgKiBHaXZlbjpcbiAgICogYGBgXG4gICAqIDxkaXY+XG4gICAqICAgPG5nLXRlbXBsYXRlPjxzcGFuPjwvc3Bhbj48L25nLXRlbXBsYXRlPlxuICAgKiA8L2Rpdj5cbiAgICogYGBgXG4gICAqXG4gICAqIFdlIGVuZCB1cCB3aXRoIHR3byBgVFZpZXdgcy5cbiAgICogLSBgcGFyZW50YCBgVFZpZXdgIHdoaWNoIGNvbnRhaW5zIGA8ZGl2PjwhLS0gYW5jaG9yIC0tPjwvZGl2PmBcbiAgICogLSBgY2hpbGRgIGBUVmlld2Agd2hpY2ggY29udGFpbnMgYDxzcGFuPjwvc3Bhbj5gXG4gICAqXG4gICAqIFR5cGljYWxseSB0aGUgYGNoaWxkYCBpcyBpbnNlcnRlZCBpbnRvIHRoZSBkZWNsYXJhdGlvbiBsb2NhdGlvbiBvZiB0aGUgYHBhcmVudGAsIGJ1dCBpdCBjYW4gYmVcbiAgICogaW5zZXJ0ZWQgYW55d2hlcmUuIEJlY2F1c2UgaXQgY2FuIGJlIGluc2VydGVkIGFueXdoZXJlIGl0IGlzIG5vdCBwb3NzaWJsZSB0byBzdG9yZSB0aGVcbiAgICogaW5zZXJ0aW9uIGluZm9ybWF0aW9uIGluIHRoZSBgVFZpZXdgIGFuZCBpbnN0ZWFkIHdlIG11c3Qgc3RvcmUgaXQgaW4gdGhlIGBMVmlld1tUX0hPU1RdYC5cbiAgICpcbiAgICogU28gdG8gZGV0ZXJtaW5lIHdoZXJlIGlzIG91ciBpbnNlcnRpb24gcGFyZW50IHdlIHdvdWxkIGV4ZWN1dGU6XG4gICAqIGBgYFxuICAgKiBjb25zdCBwYXJlbnRMVmlldyA9IGxWaWV3W1BBUkVOVF07XG4gICAqIGNvbnN0IHBhcmVudFROb2RlID0gbFZpZXdbVF9IT1NUXTtcbiAgICogY29uc3QgaW5zZXJ0aW9uUGFyZW50ID0gcGFyZW50TFZpZXdbcGFyZW50VE5vZGUuaW5kZXhdO1xuICAgKiBgYGBcbiAgICpcbiAgICpcbiAgICogSWYgYG51bGxgLCB0aGlzIGlzIHRoZSByb290IHZpZXcgb2YgYW4gYXBwbGljYXRpb24gKHJvb3QgY29tcG9uZW50IGlzIGluIHRoaXMgdmlldykgYW5kIGl0IGhhc1xuICAgKiBubyBwYXJlbnRzLlxuICAgKi9cbiAgW1RfSE9TVF06IFROb2RlfG51bGw7XG5cbiAgLyoqXG4gICAqIFdoZW4gYSB2aWV3IGlzIGRlc3Ryb3llZCwgbGlzdGVuZXJzIG5lZWQgdG8gYmUgcmVsZWFzZWQgYW5kIG91dHB1dHMgbmVlZCB0byBiZVxuICAgKiB1bnN1YnNjcmliZWQuIFRoaXMgY29udGV4dCBhcnJheSBzdG9yZXMgYm90aCBsaXN0ZW5lciBmdW5jdGlvbnMgd3JhcHBlZCB3aXRoXG4gICAqIHRoZWlyIGNvbnRleHQgYW5kIG91dHB1dCBzdWJzY3JpcHRpb24gaW5zdGFuY2VzIGZvciBhIHBhcnRpY3VsYXIgdmlldy5cbiAgICpcbiAgICogVGhlc2UgY2hhbmdlIHBlciBMVmlldyBpbnN0YW5jZSwgc28gdGhleSBjYW5ub3QgYmUgc3RvcmVkIG9uIFRWaWV3LiBJbnN0ZWFkLFxuICAgKiBUVmlldy5jbGVhbnVwIHNhdmVzIGFuIGluZGV4IHRvIHRoZSBuZWNlc3NhcnkgY29udGV4dCBpbiB0aGlzIGFycmF5LlxuICAgKlxuICAgKiBBZnRlciBgTFZpZXdgIGlzIGNyZWF0ZWQgaXQgaXMgcG9zc2libGUgdG8gYXR0YWNoIGFkZGl0aW9uYWwgaW5zdGFuY2Ugc3BlY2lmaWMgZnVuY3Rpb25zIGF0IHRoZVxuICAgKiBlbmQgb2YgdGhlIGBsVmlld1tDTEVBTlVQXWAgYmVjYXVzZSB3ZSBrbm93IHRoYXQgbm8gbW9yZSBgVGAgbGV2ZWwgY2xlYW51cCBmdW5jdGlvbnMgd2lsbCBiZVxuICAgKiBhZGRlZCBoZXJlLlxuICAgKi9cbiAgW0NMRUFOVVBdOiBhbnlbXXxudWxsO1xuXG4gIC8qKlxuICAgKiAtIEZvciBkeW5hbWljIHZpZXdzLCB0aGlzIGlzIHRoZSBjb250ZXh0IHdpdGggd2hpY2ggdG8gcmVuZGVyIHRoZSB0ZW1wbGF0ZSAoZS5nLlxuICAgKiAgIGBOZ0ZvckNvbnRleHRgKSwgb3IgYHt9YCBpZiBub3QgZGVmaW5lZCBleHBsaWNpdGx5LlxuICAgKiAtIEZvciByb290IHZpZXcgb2YgdGhlIHJvb3QgY29tcG9uZW50IGl0J3MgYSByZWZlcmVuY2UgdG8gdGhlIGNvbXBvbmVudCBpbnN0YW5jZSBpdHNlbGYuXG4gICAqIC0gRm9yIGNvbXBvbmVudHMsIHRoZSBjb250ZXh0IGlzIGEgcmVmZXJlbmNlIHRvIHRoZSBjb21wb25lbnQgaW5zdGFuY2UgaXRzZWxmLlxuICAgKiAtIEZvciBpbmxpbmUgdmlld3MsIHRoZSBjb250ZXh0IGlzIG51bGwuXG4gICAqL1xuICBbQ09OVEVYVF06IFQ7XG5cbiAgLyoqIEFuIG9wdGlvbmFsIE1vZHVsZSBJbmplY3RvciB0byBiZSB1c2VkIGFzIGZhbGwgYmFjayBhZnRlciBFbGVtZW50IEluamVjdG9ycyBhcmUgY29uc3VsdGVkLiAqL1xuICByZWFkb25seVtJTkpFQ1RPUl06IEluamVjdG9yfG51bGw7XG5cbiAgLyoqXG4gICAqIENvbnRleHR1YWwgZGF0YSB0aGF0IGlzIHNoYXJlZCBhY3Jvc3MgbXVsdGlwbGUgaW5zdGFuY2VzIG9mIGBMVmlld2AgaW4gdGhlIHNhbWUgYXBwbGljYXRpb24uXG4gICAqL1xuICBbRU5WSVJPTk1FTlRdOiBMVmlld0Vudmlyb25tZW50O1xuXG4gIC8qKiBSZW5kZXJlciB0byBiZSB1c2VkIGZvciB0aGlzIHZpZXcuICovXG4gIFtSRU5ERVJFUl06IFJlbmRlcmVyO1xuXG4gIC8qKlxuICAgKiBSZWZlcmVuY2UgdG8gdGhlIGZpcnN0IExWaWV3IG9yIExDb250YWluZXIgYmVuZWF0aCB0aGlzIExWaWV3IGluXG4gICAqIHRoZSBoaWVyYXJjaHkuXG4gICAqXG4gICAqIE5lY2Vzc2FyeSB0byBzdG9yZSB0aGlzIHNvIHZpZXdzIGNhbiB0cmF2ZXJzZSB0aHJvdWdoIHRoZWlyIG5lc3RlZCB2aWV3c1xuICAgKiB0byByZW1vdmUgbGlzdGVuZXJzIGFuZCBjYWxsIG9uRGVzdHJveSBjYWxsYmFja3MuXG4gICAqL1xuICBbQ0hJTERfSEVBRF06IExWaWV3fExDb250YWluZXJ8bnVsbDtcblxuICAvKipcbiAgICogVGhlIGxhc3QgTFZpZXcgb3IgTENvbnRhaW5lciBiZW5lYXRoIHRoaXMgTFZpZXcgaW4gdGhlIGhpZXJhcmNoeS5cbiAgICpcbiAgICogVGhlIHRhaWwgYWxsb3dzIHVzIHRvIHF1aWNrbHkgYWRkIGEgbmV3IHN0YXRlIHRvIHRoZSBlbmQgb2YgdGhlIHZpZXcgbGlzdFxuICAgKiB3aXRob3V0IGhhdmluZyB0byBwcm9wYWdhdGUgc3RhcnRpbmcgZnJvbSB0aGUgZmlyc3QgY2hpbGQuXG4gICAqL1xuICBbQ0hJTERfVEFJTF06IExWaWV3fExDb250YWluZXJ8bnVsbDtcblxuICAvKipcbiAgICogVmlldyB3aGVyZSB0aGlzIHZpZXcncyB0ZW1wbGF0ZSB3YXMgZGVjbGFyZWQuXG4gICAqXG4gICAqIFRoZSB0ZW1wbGF0ZSBmb3IgYSBkeW5hbWljYWxseSBjcmVhdGVkIHZpZXcgbWF5IGJlIGRlY2xhcmVkIGluIGEgZGlmZmVyZW50IHZpZXcgdGhhblxuICAgKiBpdCBpcyBpbnNlcnRlZC4gV2UgYWxyZWFkeSB0cmFjayB0aGUgXCJpbnNlcnRpb24gdmlld1wiICh2aWV3IHdoZXJlIHRoZSB0ZW1wbGF0ZSB3YXNcbiAgICogaW5zZXJ0ZWQpIGluIExWaWV3W1BBUkVOVF0sIGJ1dCB3ZSBhbHNvIG5lZWQgYWNjZXNzIHRvIHRoZSBcImRlY2xhcmF0aW9uIHZpZXdcIlxuICAgKiAodmlldyB3aGVyZSB0aGUgdGVtcGxhdGUgd2FzIGRlY2xhcmVkKS4gT3RoZXJ3aXNlLCB3ZSB3b3VsZG4ndCBiZSBhYmxlIHRvIGNhbGwgdGhlXG4gICAqIHZpZXcncyB0ZW1wbGF0ZSBmdW5jdGlvbiB3aXRoIHRoZSBwcm9wZXIgY29udGV4dHMuIENvbnRleHQgc2hvdWxkIGJlIGluaGVyaXRlZCBmcm9tXG4gICAqIHRoZSBkZWNsYXJhdGlvbiB2aWV3IHRyZWUsIG5vdCB0aGUgaW5zZXJ0aW9uIHZpZXcgdHJlZS5cbiAgICpcbiAgICogRXhhbXBsZSAoQXBwQ29tcG9uZW50IHRlbXBsYXRlKTpcbiAgICpcbiAgICogPG5nLXRlbXBsYXRlICNmb28+PC9uZy10ZW1wbGF0ZT4gICAgICAgPC0tIGRlY2xhcmVkIGhlcmUgLS0+XG4gICAqIDxzb21lLWNvbXAgW3RwbF09XCJmb29cIj48L3NvbWUtY29tcD4gICAgPC0tIGluc2VydGVkIGluc2lkZSB0aGlzIGNvbXBvbmVudCAtLT5cbiAgICpcbiAgICogVGhlIDxuZy10ZW1wbGF0ZT4gYWJvdmUgaXMgZGVjbGFyZWQgaW4gdGhlIEFwcENvbXBvbmVudCB0ZW1wbGF0ZSwgYnV0IGl0IHdpbGwgYmUgcGFzc2VkIGludG9cbiAgICogU29tZUNvbXAgYW5kIGluc2VydGVkIHRoZXJlLiBJbiB0aGlzIGNhc2UsIHRoZSBkZWNsYXJhdGlvbiB2aWV3IHdvdWxkIGJlIHRoZSBBcHBDb21wb25lbnQsXG4gICAqIGJ1dCB0aGUgaW5zZXJ0aW9uIHZpZXcgd291bGQgYmUgU29tZUNvbXAuIFdoZW4gd2UgYXJlIHJlbW92aW5nIHZpZXdzLCB3ZSB3b3VsZCB3YW50IHRvXG4gICAqIHRyYXZlcnNlIHRocm91Z2ggdGhlIGluc2VydGlvbiB2aWV3IHRvIGNsZWFuIHVwIGxpc3RlbmVycy4gV2hlbiB3ZSBhcmUgY2FsbGluZyB0aGVcbiAgICogdGVtcGxhdGUgZnVuY3Rpb24gZHVyaW5nIGNoYW5nZSBkZXRlY3Rpb24sIHdlIG5lZWQgdGhlIGRlY2xhcmF0aW9uIHZpZXcgdG8gZ2V0IGluaGVyaXRlZFxuICAgKiBjb250ZXh0LlxuICAgKi9cbiAgW0RFQ0xBUkFUSU9OX1ZJRVddOiBMVmlld3xudWxsO1xuXG5cbiAgLyoqXG4gICAqIFBvaW50cyB0byB0aGUgZGVjbGFyYXRpb24gY29tcG9uZW50IHZpZXcsIHVzZWQgdG8gdHJhY2sgdHJhbnNwbGFudGVkIGBMVmlld2BzLlxuICAgKlxuICAgKiBTZWU6IGBERUNMQVJBVElPTl9WSUVXYCB3aGljaCBwb2ludHMgdG8gdGhlIGFjdHVhbCBgTFZpZXdgIHdoZXJlIGl0IHdhcyBkZWNsYXJlZCwgd2hlcmVhc1xuICAgKiBgREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVdgIHBvaW50cyB0byB0aGUgY29tcG9uZW50IHdoaWNoIG1heSBub3QgYmUgc2FtZSBhc1xuICAgKiBgREVDTEFSQVRJT05fVklFV2AuXG4gICAqXG4gICAqIEV4YW1wbGU6XG4gICAqIGBgYFxuICAgKiA8I1ZJRVcgI215Q29tcD5cbiAgICogIDxkaXYgKm5nSWY9XCJ0cnVlXCI+XG4gICAqICAgPG5nLXRlbXBsYXRlICNteVRtcGw+Li4uPC9uZy10ZW1wbGF0ZT5cbiAgICogIDwvZGl2PlxuICAgKiA8LyNWSUVXPlxuICAgKiBgYGBcbiAgICogSW4gdGhlIGFib3ZlIGNhc2UgYERFQ0xBUkFUSU9OX1ZJRVdgIGZvciBgbXlUbXBsYCBwb2ludHMgdG8gdGhlIGBMVmlld2Agb2YgYG5nSWZgIHdoZXJlYXNcbiAgICogYERFQ0xBUkFUSU9OX0NPTVBPTkVOVF9WSUVXYCBwb2ludHMgdG8gYExWaWV3YCBvZiB0aGUgYG15Q29tcGAgd2hpY2ggb3ducyB0aGUgdGVtcGxhdGUuXG4gICAqXG4gICAqIFRoZSByZWFzb24gZm9yIHRoaXMgaXMgdGhhdCBhbGwgZW1iZWRkZWQgdmlld3MgYXJlIGFsd2F5cyBjaGVjay1hbHdheXMgd2hlcmVhcyB0aGUgY29tcG9uZW50XG4gICAqIHZpZXcgY2FuIGJlIGNoZWNrLWFsd2F5cyBvciBvbi1wdXNoLiBXaGVuIHdlIGhhdmUgYSB0cmFuc3BsYW50ZWQgdmlldyBpdCBpcyBpbXBvcnRhbnQgdG9cbiAgICogZGV0ZXJtaW5lIGlmIHdlIGhhdmUgdHJhbnNwbGFudGVkIGEgdmlldyBmcm9tIGNoZWNrLWFsd2F5cyBkZWNsYXJhdGlvbiB0byBvbi1wdXNoIGluc2VydGlvblxuICAgKiBwb2ludC4gSW4gc3VjaCBhIGNhc2UgdGhlIHRyYW5zcGxhbnRlZCB2aWV3IG5lZWRzIHRvIGJlIGFkZGVkIHRvIHRoZSBgTENvbnRhaW5lcmAgaW4gdGhlXG4gICAqIGRlY2xhcmVkIGBMVmlld2AgYW5kIENEIGR1cmluZyB0aGUgZGVjbGFyZWQgdmlldyBDRCAoaW4gYWRkaXRpb24gdG8gdGhlIENEIGF0IHRoZSBpbnNlcnRpb25cbiAgICogcG9pbnQuKSAoQW55IHRyYW5zcGxhbnRlZCB2aWV3cyB3aGljaCBhcmUgaW50cmEgQ29tcG9uZW50IGFyZSBvZiBubyBpbnRlcmVzdCBiZWNhdXNlIHRoZSBDRFxuICAgKiBzdHJhdGVneSBvZiBkZWNsYXJhdGlvbiBhbmQgaW5zZXJ0aW9uIHdpbGwgYWx3YXlzIGJlIHRoZSBzYW1lLCBiZWNhdXNlIGl0IGlzIHRoZSBzYW1lXG4gICAqIGNvbXBvbmVudC4pXG4gICAqXG4gICAqIFF1ZXJpZXMgYWxyZWFkeSB0cmFjayBtb3ZlZCB2aWV3cyBpbiBgTFZpZXdbREVDTEFSQVRJT05fTENPTlRBSU5FUl1gIGFuZFxuICAgKiBgTENvbnRhaW5lcltNT1ZFRF9WSUVXU11gLiBIb3dldmVyIHRoZSBxdWVyaWVzIGFsc28gdHJhY2sgYExWaWV3YHMgd2hpY2ggbW92ZWQgd2l0aGluIHRoZSBzYW1lXG4gICAqIGNvbXBvbmVudCBgTFZpZXdgLiBUcmFuc3BsYW50ZWQgdmlld3MgYXJlIGEgc3Vic2V0IG9mIG1vdmVkIHZpZXdzLCBhbmQgd2UgdXNlXG4gICAqIGBERUNMQVJBVElPTl9DT01QT05FTlRfVklFV2AgdG8gZGlmZmVyZW50aWF0ZSB0aGVtLiBBcyBpbiB0aGlzIGV4YW1wbGUuXG4gICAqXG4gICAqIEV4YW1wbGUgc2hvd2luZyBpbnRyYSBjb21wb25lbnQgYExWaWV3YCBtb3ZlbWVudC5cbiAgICogYGBgXG4gICAqIDwjVklFVyAjbXlDb21wPlxuICAgKiAgIDxkaXYgKm5nSWY9XCJjb25kaXRpb247IHRoZW4gdGhlbkJsb2NrIGVsc2UgZWxzZUJsb2NrXCI+PC9kaXY+XG4gICAqICAgPG5nLXRlbXBsYXRlICN0aGVuQmxvY2s+Q29udGVudCB0byByZW5kZXIgd2hlbiBjb25kaXRpb24gaXMgdHJ1ZS48L25nLXRlbXBsYXRlPlxuICAgKiAgIDxuZy10ZW1wbGF0ZSAjZWxzZUJsb2NrPkNvbnRlbnQgdG8gcmVuZGVyIHdoZW4gY29uZGl0aW9uIGlzIGZhbHNlLjwvbmctdGVtcGxhdGU+XG4gICAqIDwvI1ZJRVc+XG4gICAqIGBgYFxuICAgKiBUaGUgYHRoZW5CbG9ja2AgYW5kIGBlbHNlQmxvY2tgIGlzIG1vdmVkIGJ1dCBub3QgdHJhbnNwbGFudGVkLlxuICAgKlxuICAgKiBFeGFtcGxlIHNob3dpbmcgaW50ZXIgY29tcG9uZW50IGBMVmlld2AgbW92ZW1lbnQgKHRyYW5zcGxhbnRlZCB2aWV3KS5cbiAgICogYGBgXG4gICAqIDwjVklFVyAjbXlDb21wPlxuICAgKiAgIDxuZy10ZW1wbGF0ZSAjbXlUbXBsPi4uLjwvbmctdGVtcGxhdGU+XG4gICAqICAgPGluc2VydGlvbi1jb21wb25lbnQgW3RlbXBsYXRlXT1cIm15VG1wbFwiPjwvaW5zZXJ0aW9uLWNvbXBvbmVudD5cbiAgICogPC8jVklFVz5cbiAgICogYGBgXG4gICAqIEluIHRoZSBhYm92ZSBleGFtcGxlIGBteVRtcGxgIGlzIHBhc3NlZCBpbnRvIGEgZGlmZmVyZW50IGNvbXBvbmVudC4gSWYgYGluc2VydGlvbi1jb21wb25lbnRgXG4gICAqIGluc3RhbnRpYXRlcyBgbXlUbXBsYCBhbmQgYGluc2VydGlvbi1jb21wb25lbnRgIGlzIG9uLXB1c2ggdGhlbiB0aGUgYExDb250YWluZXJgIG5lZWRzIHRvIGJlXG4gICAqIG1hcmtlZCBhcyBjb250YWluaW5nIHRyYW5zcGxhbnRlZCB2aWV3cyBhbmQgdGhvc2Ugdmlld3MgbmVlZCB0byBiZSBDRCBhcyBwYXJ0IG9mIHRoZVxuICAgKiBkZWNsYXJhdGlvbiBDRC5cbiAgICpcbiAgICpcbiAgICogV2hlbiBjaGFuZ2UgZGV0ZWN0aW9uIHJ1bnMsIGl0IGl0ZXJhdGVzIG92ZXIgYFtNT1ZFRF9WSUVXU11gIGFuZCBDRHMgYW55IGNoaWxkIGBMVmlld2BzIHdoZXJlXG4gICAqIHRoZSBgREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVdgIG9mIHRoZSBjdXJyZW50IGNvbXBvbmVudCBhbmQgdGhlIGNoaWxkIGBMVmlld2AgZG9lcyBub3QgbWF0Y2hcbiAgICogKGl0IGhhcyBiZWVuIHRyYW5zcGxhbnRlZCBhY3Jvc3MgY29tcG9uZW50cy4pXG4gICAqXG4gICAqIE5vdGU6IGBbREVDTEFSQVRJT05fQ09NUE9ORU5UX1ZJRVddYCBwb2ludHMgdG8gaXRzZWxmIGlmIHRoZSBMVmlldyBpcyBhIGNvbXBvbmVudCB2aWV3ICh0aGVcbiAgICogICAgICAgc2ltcGxlc3QgLyBtb3N0IGNvbW1vbiBjYXNlKS5cbiAgICpcbiAgICogc2VlIGFsc286XG4gICAqICAgLSBodHRwczovL2hhY2ttZC5pby9AbWhldmVyeS9ySlVKc3Z2OUggd3JpdGUgdXAgb2YgdGhlIHByb2JsZW1cbiAgICogICAtIGBMQ29udGFpbmVyW0hBU19UUkFOU1BMQU5URURfVklFV1NdYCB3aGljaCBtYXJrcyB3aGljaCBgTENvbnRhaW5lcmAgaGFzIHRyYW5zcGxhbnRlZCB2aWV3cy5cbiAgICogICAtIGBMQ29udGFpbmVyW1RSQU5TUExBTlRfSEVBRF1gIGFuZCBgTENvbnRhaW5lcltUUkFOU1BMQU5UX1RBSUxdYCBzdG9yYWdlIGZvciB0cmFuc3BsYW50ZWRcbiAgICogICAtIGBMVmlld1tERUNMQVJBVElPTl9MQ09OVEFJTkVSXWAgc2ltaWxhciBwcm9ibGVtIGZvciBxdWVyaWVzXG4gICAqICAgLSBgTENvbnRhaW5lcltNT1ZFRF9WSUVXU11gIHNpbWlsYXIgcHJvYmxlbSBmb3IgcXVlcmllc1xuICAgKi9cbiAgW0RFQ0xBUkFUSU9OX0NPTVBPTkVOVF9WSUVXXTogTFZpZXc7XG5cbiAgLyoqXG4gICAqIEEgZGVjbGFyYXRpb24gcG9pbnQgb2YgZW1iZWRkZWQgdmlld3MgKG9uZXMgaW5zdGFudGlhdGVkIGJhc2VkIG9uIHRoZSBjb250ZW50IG9mIGFcbiAgICogPG5nLXRlbXBsYXRlPiksIG51bGwgZm9yIG90aGVyIHR5cGVzIG9mIHZpZXdzLlxuICAgKlxuICAgKiBXZSBuZWVkIHRvIHRyYWNrIGFsbCBlbWJlZGRlZCB2aWV3cyBjcmVhdGVkIGZyb20gYSBnaXZlbiBkZWNsYXJhdGlvbiBwb2ludCBzbyB3ZSBjYW4gcHJlcGFyZVxuICAgKiBxdWVyeSBtYXRjaGVzIGluIGEgcHJvcGVyIG9yZGVyIChxdWVyeSBtYXRjaGVzIGFyZSBvcmRlcmVkIGJhc2VkIG9uIHRoZWlyIGRlY2xhcmF0aW9uIHBvaW50IGFuZFxuICAgKiBfbm90XyB0aGUgaW5zZXJ0aW9uIHBvaW50KS5cbiAgICovXG4gIFtERUNMQVJBVElPTl9MQ09OVEFJTkVSXTogTENvbnRhaW5lcnxudWxsO1xuXG4gIC8qKlxuICAgKiBNb3JlIGZsYWdzIGZvciB0aGlzIHZpZXcuIFNlZSBQcmVPcmRlckhvb2tGbGFncyBmb3IgbW9yZSBpbmZvLlxuICAgKi9cbiAgW1BSRU9SREVSX0hPT0tfRkxBR1NdOiBQcmVPcmRlckhvb2tGbGFncztcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBkaXJlY3QgdHJhbnNwbGFudGVkIHZpZXdzIHdoaWNoIG5lZWQgYSByZWZyZXNoIG9yIGhhdmUgZGVzY2VuZGFudHMgdGhlbXNlbHZlc1xuICAgKiB0aGF0IG5lZWQgYSByZWZyZXNoIGJ1dCBoYXZlIG5vdCBtYXJrZWQgdGhlaXIgYW5jZXN0b3JzIGFzIERpcnR5LiBUaGlzIHRlbGxzIHVzIHRoYXQgZHVyaW5nXG4gICAqIGNoYW5nZSBkZXRlY3Rpb24gd2Ugc2hvdWxkIHN0aWxsIGRlc2NlbmQgdG8gZmluZCB0aG9zZSBjaGlsZHJlbiB0byByZWZyZXNoLCBldmVuIGlmIHRoZSBwYXJlbnRzXG4gICAqIGFyZSBub3QgYERpcnR5YC9gQ2hlY2tBbHdheXNgLlxuICAgKi9cbiAgW0RFU0NFTkRBTlRfVklFV1NfVE9fUkVGUkVTSF06IG51bWJlcjtcblxuICAvKiogVW5pcXVlIElEIG9mIHRoZSB2aWV3LiBVc2VkIGZvciBgX19uZ0NvbnRleHRfX2AgbG9va3VwcyBpbiB0aGUgYExWaWV3YCByZWdpc3RyeS4gKi9cbiAgW0lEXTogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBBIGNvbnRhaW5lciByZWxhdGVkIHRvIGh5ZHJhdGlvbiBhbm5vdGF0aW9uIGluZm9ybWF0aW9uIHRoYXQncyBhc3NvY2lhdGVkIHdpdGggdGhpcyBMVmlldy5cbiAgICovXG4gIFtIWURSQVRJT05dOiBEZWh5ZHJhdGVkVmlld3xudWxsO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBpbmplY3RvciBhc3NpZ25lZCB0byBlbWJlZGRlZCB2aWV3cyB0aGF0IHRha2VzXG4gICAqIHByZWNlZGVuY2Ugb3ZlciB0aGUgZWxlbWVudCBhbmQgbW9kdWxlIGluamVjdG9ycy5cbiAgICovXG4gIHJlYWRvbmx5W0VNQkVEREVEX1ZJRVdfSU5KRUNUT1JdOiBJbmplY3RvcnxudWxsO1xuXG4gIC8qKlxuICAgKiBBIGNvbGxlY3Rpb24gb2YgY2FsbGJhY2tzIGZ1bmN0aW9ucyB0aGF0IGFyZSBleGVjdXRlZCB3aGVuIGEgZ2l2ZW4gTFZpZXcgaXMgZGVzdHJveWVkLiBUaG9zZVxuICAgKiBhcmUgdXNlciBkZWZpbmVkLCBMVmlldy1zcGVjaWZpYyBkZXN0cm95IGNhbGxiYWNrcyB0aGF0IGRvbid0IGhhdmUgYW55IGNvcnJlc3BvbmRpbmcgVFZpZXdcbiAgICogZW50cmllcy5cbiAgICovXG4gIFtPTl9ERVNUUk9ZX0hPT0tTXTogQXJyYXk8KCkgPT4gdm9pZD58bnVsbDtcblxuICAvKipcbiAgICogVGhlIGBDb25zdW1lcmAgZm9yIHRoaXMgYExWaWV3YCdzIHRlbXBsYXRlIHNvIHRoYXQgc2lnbmFsIHJlYWRzIGNhbiBiZSB0cmFja2VkLlxuICAgKlxuICAgKiBUaGlzIGlzIGluaXRpYWxseSBgbnVsbGAgYW5kIGdldHMgYXNzaWduZWQgYSBjb25zdW1lciBhZnRlciB0ZW1wbGF0ZSBleGVjdXRpb25cbiAgICogaWYgYW55IHNpZ25hbHMgd2VyZSByZWFkLlxuICAgKi9cbiAgW1JFQUNUSVZFX1RFTVBMQVRFX0NPTlNVTUVSXTogUmVhY3RpdmVMVmlld0NvbnN1bWVyfG51bGw7XG5cbiAgLyoqXG4gICAqIFNhbWUgYXMgUkVBQ1RJVkVfVEVNUExBVEVfQ09OU1VNRVIsIGJ1dCBmb3IgdGhlIGhvc3QgYmluZGluZ3Mgb2YgdGhlIExWaWV3LlxuICAgKi9cbiAgW1JFQUNUSVZFX0hPU1RfQklORElOR19DT05TVU1FUl06IFJlYWN0aXZlTFZpZXdDb25zdW1lcnxudWxsO1xufVxuXG4vKipcbiAqIENvbnRleHR1YWwgZGF0YSB0aGF0IGlzIHNoYXJlZCBhY3Jvc3MgbXVsdGlwbGUgaW5zdGFuY2VzIG9mIGBMVmlld2AgaW4gdGhlIHNhbWUgYXBwbGljYXRpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTFZpZXdFbnZpcm9ubWVudCB7XG4gIC8qKiBGYWN0b3J5IHRvIGJlIHVzZWQgZm9yIGNyZWF0aW5nIFJlbmRlcmVyLiAqL1xuICByZW5kZXJlckZhY3Rvcnk6IFJlbmRlcmVyRmFjdG9yeTtcblxuICAvKiogQW4gb3B0aW9uYWwgY3VzdG9tIHNhbml0aXplci4gKi9cbiAgc2FuaXRpemVyOiBTYW5pdGl6ZXJ8bnVsbDtcblxuICAvKiogQ29udGFpbmVyIGZvciByZWFjdGl2aXR5IHN5c3RlbSBgZWZmZWN0YHMuICovXG4gIGVmZmVjdE1hbmFnZXI6IEVmZmVjdE1hbmFnZXJ8bnVsbDtcblxuICAvKiogQ29udGFpbmVyIGZvciBhZnRlciByZW5kZXIgaG9va3MgKi9cbiAgYWZ0ZXJSZW5kZXJFdmVudE1hbmFnZXI6IEFmdGVyUmVuZGVyRXZlbnRNYW5hZ2VyfG51bGw7XG59XG5cbi8qKiBGbGFncyBhc3NvY2lhdGVkIHdpdGggYW4gTFZpZXcgKHNhdmVkIGluIExWaWV3W0ZMQUdTXSkgKi9cbmV4cG9ydCBjb25zdCBlbnVtIExWaWV3RmxhZ3Mge1xuICAvKiogVGhlIHN0YXRlIG9mIHRoZSBpbml0IHBoYXNlIG9uIHRoZSBmaXJzdCAyIGJpdHMgKi9cbiAgSW5pdFBoYXNlU3RhdGVJbmNyZW1lbnRlciA9IDBiMDAwMDAwMDAwMDEsXG4gIEluaXRQaGFzZVN0YXRlTWFzayA9IDBiMDAwMDAwMDAwMTEsXG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IHRoZSB2aWV3IGlzIGluIGNyZWF0aW9uTW9kZS5cbiAgICpcbiAgICogVGhpcyBtdXN0IGJlIHN0b3JlZCBpbiB0aGUgdmlldyByYXRoZXIgdGhhbiB1c2luZyBgZGF0YWAgYXMgYSBtYXJrZXIgc28gdGhhdFxuICAgKiB3ZSBjYW4gcHJvcGVybHkgc3VwcG9ydCBlbWJlZGRlZCB2aWV3cy4gT3RoZXJ3aXNlLCB3aGVuIGV4aXRpbmcgYSBjaGlsZCB2aWV3XG4gICAqIGJhY2sgaW50byB0aGUgcGFyZW50IHZpZXcsIGBkYXRhYCB3aWxsIGJlIGRlZmluZWQgYW5kIGBjcmVhdGlvbk1vZGVgIHdpbGwgYmVcbiAgICogaW1wcm9wZXJseSByZXBvcnRlZCBhcyBmYWxzZS5cbiAgICovXG4gIENyZWF0aW9uTW9kZSA9IDEgPDwgMixcblxuICAvKipcbiAgICogV2hldGhlciBvciBub3QgdGhpcyBMVmlldyBpbnN0YW5jZSBpcyBvbiBpdHMgZmlyc3QgcHJvY2Vzc2luZyBwYXNzLlxuICAgKlxuICAgKiBBbiBMVmlldyBpbnN0YW5jZSBpcyBjb25zaWRlcmVkIHRvIGJlIG9uIGl0cyBcImZpcnN0IHBhc3NcIiB1bnRpbCBpdFxuICAgKiBoYXMgY29tcGxldGVkIG9uZSBjcmVhdGlvbiBtb2RlIHJ1biBhbmQgb25lIHVwZGF0ZSBtb2RlIHJ1bi4gQXQgdGhpc1xuICAgKiB0aW1lLCB0aGUgZmxhZyBpcyB0dXJuZWQgb2ZmLlxuICAgKi9cbiAgRmlyc3RMVmlld1Bhc3MgPSAxIDw8IDMsXG5cbiAgLyoqIFdoZXRoZXIgdGhpcyB2aWV3IGhhcyBkZWZhdWx0IGNoYW5nZSBkZXRlY3Rpb24gc3RyYXRlZ3kgKGNoZWNrcyBhbHdheXMpIG9yIG9uUHVzaCAqL1xuICBDaGVja0Fsd2F5cyA9IDEgPDwgNCxcblxuICAvKiogV2hldGhlciB0aGVyZSBhcmUgYW55IGkxOG4gYmxvY2tzIGluc2lkZSB0aGlzIExWaWV3LiAqL1xuICBIYXNJMThuID0gMSA8PCA1LFxuXG4gIC8qKiBXaGV0aGVyIG9yIG5vdCB0aGlzIHZpZXcgaXMgY3VycmVudGx5IGRpcnR5IChuZWVkaW5nIGNoZWNrKSAqL1xuICBEaXJ0eSA9IDEgPDwgNixcblxuICAvKiogV2hldGhlciBvciBub3QgdGhpcyB2aWV3IGlzIGN1cnJlbnRseSBhdHRhY2hlZCB0byBjaGFuZ2UgZGV0ZWN0aW9uIHRyZWUuICovXG4gIEF0dGFjaGVkID0gMSA8PCA3LFxuXG4gIC8qKiBXaGV0aGVyIG9yIG5vdCB0aGlzIHZpZXcgaXMgZGVzdHJveWVkLiAqL1xuICBEZXN0cm95ZWQgPSAxIDw8IDgsXG5cbiAgLyoqIFdoZXRoZXIgb3Igbm90IHRoaXMgdmlldyBpcyB0aGUgcm9vdCB2aWV3ICovXG4gIElzUm9vdCA9IDEgPDwgOSxcblxuICAvKipcbiAgICogV2hldGhlciB0aGlzIG1vdmVkIExWaWV3IHdhcyBuZWVkcyB0byBiZSByZWZyZXNoZWQuIFNpbWlsYXIgdG8gdGhlIERpcnR5IGZsYWcsIGJ1dCB1c2VkIGZvclxuICAgKiB0cmFuc3BsYW50ZWQgYW5kIHNpZ25hbCB2aWV3cyB3aGVyZSB0aGUgcGFyZW50L2FuY2VzdG9yIHZpZXdzIGFyZSBub3QgbWFya2VkIGRpcnR5IGFzIHdlbGwuXG4gICAqIGkuZS4gXCJSZWZyZXNoIGp1c3QgdGhpcyB2aWV3XCIuIFVzZWQgaW4gY29uanVuY3Rpb24gd2l0aCB0aGUgREVTQ0VOREFOVF9WSUVXU19UT19SRUZSRVNIXG4gICAqIGNvdW50ZXIuXG4gICAqL1xuICBSZWZyZXNoVmlldyA9IDEgPDwgMTAsXG5cbiAgLyoqIEluZGljYXRlcyB0aGF0IHRoZSB2aWV3ICoqb3IgYW55IG9mIGl0cyBhbmNlc3RvcnMqKiBoYXZlIGFuIGVtYmVkZGVkIHZpZXcgaW5qZWN0b3IuICovXG4gIEhhc0VtYmVkZGVkVmlld0luamVjdG9yID0gMSA8PCAxMSxcblxuICAvKiogSW5kaWNhdGVzIHRoYXQgdGhlIHZpZXcgd2FzIGNyZWF0ZWQgd2l0aCBgc2lnbmFsczogdHJ1ZWAuICovXG4gIFNpZ25hbFZpZXcgPSAxIDw8IDEyLFxuXG4gIC8qKlxuICAgKiBUaGlzIGlzIHRoZSBjb3VudCBvZiB0aGUgYml0cyB0aGUgMSB3YXMgc2hpZnRlZCBhYm92ZSAoYmFzZSAxMClcbiAgICovXG4gIEluZGV4V2l0aGluSW5pdFBoYXNlU2hpZnQgPSAxMyxcblxuICAvKipcbiAgICogSW5kZXggb2YgdGhlIGN1cnJlbnQgaW5pdCBwaGFzZSBvbiBsYXN0IDIxIGJpdHNcbiAgICovXG4gIEluZGV4V2l0aGluSW5pdFBoYXNlSW5jcmVtZW50ZXIgPSAxIDw8IEluZGV4V2l0aGluSW5pdFBoYXNlU2hpZnQsXG5cbiAgLy8gU3VidHJhY3RpbmcgMSBnaXZlcyBhbGwgMXMgdG8gdGhlIHJpZ2h0IG9mIHRoZSBpbml0aWFsIHNoaWZ0XG4gIC8vIFNvIGAoMSA8PCAzKSAtIDFgIHdvdWxkIGdpdmUgMyAxczogMSA8PCAzID0gMGIwMTAwMCwgc3VidHJhY3QgMSA9IDBiMDAxMTFcbiAgSW5kZXhXaXRoaW5Jbml0UGhhc2VSZXNldCA9ICgxIDw8IEluZGV4V2l0aGluSW5pdFBoYXNlU2hpZnQpIC0gMSxcbn1cblxuLyoqXG4gKiBQb3NzaWJsZSBzdGF0ZXMgb2YgdGhlIGluaXQgcGhhc2U6XG4gKiAtIDAwOiBPbkluaXQgaG9va3MgdG8gYmUgcnVuLlxuICogLSAwMTogQWZ0ZXJDb250ZW50SW5pdCBob29rcyB0byBiZSBydW5cbiAqIC0gMTA6IEFmdGVyVmlld0luaXQgaG9va3MgdG8gYmUgcnVuXG4gKiAtIDExOiBBbGwgaW5pdCBob29rcyBoYXZlIGJlZW4gcnVuXG4gKi9cbmV4cG9ydCBjb25zdCBlbnVtIEluaXRQaGFzZVN0YXRlIHtcbiAgT25Jbml0SG9va3NUb0JlUnVuID0gMGIwMCxcbiAgQWZ0ZXJDb250ZW50SW5pdEhvb2tzVG9CZVJ1biA9IDBiMDEsXG4gIEFmdGVyVmlld0luaXRIb29rc1RvQmVSdW4gPSAwYjEwLFxuICBJbml0UGhhc2VDb21wbGV0ZWQgPSAwYjExLFxufVxuXG4vKiogTW9yZSBmbGFncyBhc3NvY2lhdGVkIHdpdGggYW4gTFZpZXcgKHNhdmVkIGluIExWaWV3W1BSRU9SREVSX0hPT0tfRkxBR1NdKSAqL1xuZXhwb3J0IGNvbnN0IGVudW0gUHJlT3JkZXJIb29rRmxhZ3Mge1xuICAvKipcbiAgICAgVGhlIGluZGV4IG9mIHRoZSBuZXh0IHByZS1vcmRlciBob29rIHRvIGJlIGNhbGxlZCBpbiB0aGUgaG9va3MgYXJyYXksIG9uIHRoZSBmaXJzdCAxNlxuICAgICBiaXRzXG4gICAqL1xuICBJbmRleE9mVGhlTmV4dFByZU9yZGVySG9va01hc2tNYXNrID0gMGIwMTExMTExMTExMTExMTExMSxcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBpbml0IGhvb2tzIHRoYXQgaGF2ZSBhbHJlYWR5IGJlZW4gY2FsbGVkLCBvbiB0aGUgbGFzdCAxNiBiaXRzXG4gICAqL1xuICBOdW1iZXJPZkluaXRIb29rc0NhbGxlZEluY3JlbWVudGVyID0gMGIwMTAwMDAwMDAwMDAwMDAwMDAsXG4gIE51bWJlck9mSW5pdEhvb2tzQ2FsbGVkU2hpZnQgPSAxNixcbiAgTnVtYmVyT2ZJbml0SG9va3NDYWxsZWRNYXNrID0gMGIxMTExMTExMTExMTExMTExMDAwMDAwMDAwMDAwMDAwMCxcbn1cblxuLyoqXG4gKiBTdG9yZXMgYSBzZXQgb2YgT3BDb2RlcyB0byBwcm9jZXNzIGBIb3N0QmluZGluZ3NGdW5jdGlvbmAgYXNzb2NpYXRlZCB3aXRoIGEgY3VycmVudCB2aWV3LlxuICpcbiAqIEluIG9yZGVyIHRvIGludm9rZSBgSG9zdEJpbmRpbmdzRnVuY3Rpb25gIHdlIG5lZWQ6XG4gKiAxLiAnZWxlbWVudElkeGA6IEluZGV4IHRvIHRoZSBlbGVtZW50IGFzc29jaWF0ZWQgd2l0aCB0aGUgYEhvc3RCaW5kaW5nc0Z1bmN0aW9uYC5cbiAqIDIuICdkaXJlY3RpdmVJZHhgOiBJbmRleCB0byB0aGUgZGlyZWN0aXZlIGFzc29jaWF0ZWQgd2l0aCB0aGUgYEhvc3RCaW5kaW5nc0Z1bmN0aW9uYC4gKFRoaXMgd2lsbFxuICogICAgYmVjb21lIHRoZSBjb250ZXh0IGZvciB0aGUgYEhvc3RCaW5kaW5nc0Z1bmN0aW9uYCBpbnZvY2F0aW9uLilcbiAqIDMuIGBiaW5kaW5nUm9vdElkeGA6IExvY2F0aW9uIHdoZXJlIHRoZSBiaW5kaW5ncyBmb3IgdGhlIGBIb3N0QmluZGluZ3NGdW5jdGlvbmAgc3RhcnQuIEludGVybmFsbHlcbiAqICAgIGBIb3N0QmluZGluZ3NGdW5jdGlvbmAgYmluZGluZyBpbmRleGVzIHN0YXJ0IGZyb20gYDBgIHNvIHdlIG5lZWQgdG8gYWRkIGBiaW5kaW5nUm9vdElkeGAgdG9cbiAqICAgIGl0LlxuICogNC4gYEhvc3RCaW5kaW5nc0Z1bmN0aW9uYDogQSBob3N0IGJpbmRpbmcgZnVuY3Rpb24gdG8gZXhlY3V0ZS5cbiAqXG4gKiBUaGUgYWJvdmUgaW5mb3JtYXRpb24gbmVlZHMgdG8gYmUgZW5jb2RlZCBpbnRvIHRoZSBgSG9zdEJpbmRpbmdPcENvZGVzYCBpbiBhbiBlZmZpY2llbnQgbWFubmVyLlxuICpcbiAqIDEuIGBlbGVtZW50SWR4YCBpcyBlbmNvZGVkIGludG8gdGhlIGBIb3N0QmluZGluZ09wQ29kZXNgIGFzIGB+ZWxlbWVudElkeGAgKHNvIGEgbmVnYXRpdmUgbnVtYmVyKTtcbiAqIDIuIGBkaXJlY3RpdmVJZHhgXG4gKiAzLiBgYmluZGluZ1Jvb3RJZHhgXG4gKiA0LiBgSG9zdEJpbmRpbmdzRnVuY3Rpb25gIGlzIHBhc3NlZCBpbiBhcyBpcy5cbiAqXG4gKiBUaGUgYEhvc3RCaW5kaW5nT3BDb2Rlc2AgYXJyYXkgY29udGFpbnM6XG4gKiAtIG5lZ2F0aXZlIG51bWJlciB0byBzZWxlY3QgdGhlIGVsZW1lbnQgaW5kZXguXG4gKiAtIGZvbGxvd2VkIGJ5IDEgb3IgbW9yZSBvZjpcbiAqICAgIC0gYSBudW1iZXIgdG8gc2VsZWN0IHRoZSBkaXJlY3RpdmUgaW5kZXhcbiAqICAgIC0gYSBudW1iZXIgdG8gc2VsZWN0IHRoZSBiaW5kaW5nUm9vdCBpbmRleFxuICogICAgLSBhbmQgYSBmdW5jdGlvbiB0byBpbnZva2UuXG4gKlxuICogIyMgRXhhbXBsZVxuICpcbiAqIGBgYFxuICogY29uc3QgaG9zdEJpbmRpbmdPcENvZGVzID0gW1xuICogICB+MzAsICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIFNlbGVjdCBlbGVtZW50IDMwXG4gKiAgIDQwLCA0NSwgTXlEaXIuybVkaXIuaG9zdEJpbmRpbmdzICAgIC8vIEludm9rZSBob3N0IGJpbmRpbmdzIG9uIE15RGlyIG9uIGVsZW1lbnQgMzA7XG4gKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gZGlyZWN0aXZlSWR4ID0gNDA7IGJpbmRpbmdSb290SWR4ID0gNDU7XG4gKiAgIDUwLCA1NSwgT3RoZXJEaXIuybVkaXIuaG9zdEJpbmRpbmdzIC8vIEludm9rZSBob3N0IGJpbmRpbmdzIG9uIE90aGVyRGlyZSBvbiBlbGVtZW50IDMwXG4gKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gZGlyZWN0aXZlSWR4ID0gNTA7IGJpbmRpbmdSb290SWR4ID0gNTU7XG4gKiBdXG4gKiBgYGBcbiAqXG4gKiAjIyBQc2V1ZG9jb2RlXG4gKiBgYGBcbiAqIGNvbnN0IGhvc3RCaW5kaW5nT3BDb2RlcyA9IHRWaWV3Lmhvc3RCaW5kaW5nT3BDb2RlcztcbiAqIGlmIChob3N0QmluZGluZ09wQ29kZXMgPT09IG51bGwpIHJldHVybjtcbiAqIGZvciAobGV0IGkgPSAwOyBpIDwgaG9zdEJpbmRpbmdPcENvZGVzLmxlbmd0aDsgaSsrKSB7XG4gKiAgIGNvbnN0IG9wQ29kZSA9IGhvc3RCaW5kaW5nT3BDb2Rlc1tpXSBhcyBudW1iZXI7XG4gKiAgIGlmIChvcENvZGUgPCAwKSB7XG4gKiAgICAgLy8gTmVnYXRpdmUgbnVtYmVycyBhcmUgZWxlbWVudCBpbmRleGVzLlxuICogICAgIHNldFNlbGVjdGVkSW5kZXgofm9wQ29kZSk7XG4gKiAgIH0gZWxzZSB7XG4gKiAgICAgLy8gUG9zaXRpdmUgbnVtYmVycyBhcmUgTnVtYmVyVHVwbGUgd2hpY2ggc3RvcmUgYmluZGluZ1Jvb3RJbmRleCBhbmQgZGlyZWN0aXZlSW5kZXguXG4gKiAgICAgY29uc3QgZGlyZWN0aXZlSWR4ID0gb3BDb2RlO1xuICogICAgIGNvbnN0IGJpbmRpbmdSb290SW5keCA9IGhvc3RCaW5kaW5nT3BDb2Rlc1srK2ldIGFzIG51bWJlcjtcbiAqICAgICBjb25zdCBob3N0QmluZGluZ0ZuID0gaG9zdEJpbmRpbmdPcENvZGVzWysraV0gYXMgSG9zdEJpbmRpbmdzRnVuY3Rpb248YW55PjtcbiAqICAgICBzZXRCaW5kaW5nUm9vdEZvckhvc3RCaW5kaW5ncyhiaW5kaW5nUm9vdEluZHgsIGRpcmVjdGl2ZUlkeCk7XG4gKiAgICAgY29uc3QgY29udGV4dCA9IGxWaWV3W2RpcmVjdGl2ZUlkeF07XG4gKiAgICAgaG9zdEJpbmRpbmdGbihSZW5kZXJGbGFncy5VcGRhdGUsIGNvbnRleHQpO1xuICogICB9XG4gKiB9XG4gKiBgYGBcbiAqXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSG9zdEJpbmRpbmdPcENvZGVzIGV4dGVuZHMgQXJyYXk8bnVtYmVyfEhvc3RCaW5kaW5nc0Z1bmN0aW9uPGFueT4+IHtcbiAgX19icmFuZF9fOiAnSG9zdEJpbmRpbmdPcENvZGVzJztcbiAgZGVidWc/OiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBFeHBsaWNpdGx5IG1hcmtzIGBUVmlld2AgYXMgYSBzcGVjaWZpYyB0eXBlIGluIGBuZ0Rldk1vZGVgXG4gKlxuICogSXQgaXMgdXNlZnVsIHRvIGtub3cgY29uY2VwdHVhbGx5IHdoYXQgdGltZSBvZiBgVFZpZXdgIHdlIGFyZSBkZWFsaW5nIHdpdGggd2hlblxuICogZGVidWdnaW5nIGFuIGFwcGxpY2F0aW9uIChldmVuIGlmIHRoZSBydW50aW1lIGRvZXMgbm90IG5lZWQgaXQuKSBGb3IgdGhpcyByZWFzb25cbiAqIHdlIHN0b3JlIHRoaXMgaW5mb3JtYXRpb24gaW4gdGhlIGBuZ0Rldk1vZGVgIGBUVmlld2AgYW5kIHRoYW4gdXNlIGl0IGZvclxuICogYmV0dGVyIGRlYnVnZ2luZyBleHBlcmllbmNlLlxuICovXG5leHBvcnQgY29uc3QgZW51bSBUVmlld1R5cGUge1xuICAvKipcbiAgICogUm9vdCBgVFZpZXdgIGlzIHRoZSB1c2VkIHRvIGJvb3RzdHJhcCBjb21wb25lbnRzIGludG8uIEl0IGlzIHVzZWQgaW4gY29uanVuY3Rpb24gd2l0aFxuICAgKiBgTFZpZXdgIHdoaWNoIHRha2VzIGFuIGV4aXN0aW5nIERPTSBub2RlIG5vdCBvd25lZCBieSBBbmd1bGFyIGFuZCB3cmFwcyBpdCBpbiBgVFZpZXdgL2BMVmlld2BcbiAgICogc28gdGhhdCBvdGhlciBjb21wb25lbnRzIGNhbiBiZSBsb2FkZWQgaW50byBpdC5cbiAgICovXG4gIFJvb3QgPSAwLFxuXG4gIC8qKlxuICAgKiBgVFZpZXdgIGFzc29jaWF0ZWQgd2l0aCBhIENvbXBvbmVudC4gVGhpcyB3b3VsZCBiZSB0aGUgYFRWaWV3YCBkaXJlY3RseSBhc3NvY2lhdGVkIHdpdGggdGhlXG4gICAqIGNvbXBvbmVudCB2aWV3IChhcyBvcHBvc2VkIGFuIGBFbWJlZGRlZGAgYFRWaWV3YCB3aGljaCB3b3VsZCBiZSBhIGNoaWxkIG9mIGBDb21wb25lbnRgIGBUVmlld2ApXG4gICAqL1xuICBDb21wb25lbnQgPSAxLFxuXG4gIC8qKlxuICAgKiBgVFZpZXdgIGFzc29jaWF0ZWQgd2l0aCBhIHRlbXBsYXRlLiBTdWNoIGFzIGAqbmdJZmAsIGA8bmctdGVtcGxhdGU+YCBldGMuLi4gQSBgQ29tcG9uZW50YFxuICAgKiBjYW4gaGF2ZSB6ZXJvIG9yIG1vcmUgYEVtYmVkZGVkYCBgVFZpZXdgcy5cbiAgICovXG4gIEVtYmVkZGVkID0gMixcbn1cblxuLyoqXG4gKiBUaGUgc3RhdGljIGRhdGEgZm9yIGFuIExWaWV3IChzaGFyZWQgYmV0d2VlbiBhbGwgdGVtcGxhdGVzIG9mIGFcbiAqIGdpdmVuIHR5cGUpLlxuICpcbiAqIFN0b3JlZCBvbiB0aGUgYENvbXBvbmVudERlZi50Vmlld2AuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVFZpZXcge1xuICAvKipcbiAgICogVHlwZSBvZiBgVFZpZXdgIChgUm9vdGB8YENvbXBvbmVudGB8YEVtYmVkZGVkYCkuXG4gICAqL1xuICB0eXBlOiBUVmlld1R5cGU7XG5cbiAgLyoqXG4gICAqIFRoaXMgaXMgYSBibHVlcHJpbnQgdXNlZCB0byBnZW5lcmF0ZSBMVmlldyBpbnN0YW5jZXMgZm9yIHRoaXMgVFZpZXcuIENvcHlpbmcgdGhpc1xuICAgKiBibHVlcHJpbnQgaXMgZmFzdGVyIHRoYW4gY3JlYXRpbmcgYSBuZXcgTFZpZXcgZnJvbSBzY3JhdGNoLlxuICAgKi9cbiAgYmx1ZXByaW50OiBMVmlldztcblxuICAvKipcbiAgICogVGhlIHRlbXBsYXRlIGZ1bmN0aW9uIHVzZWQgdG8gcmVmcmVzaCB0aGUgdmlldyBvZiBkeW5hbWljYWxseSBjcmVhdGVkIHZpZXdzXG4gICAqIGFuZCBjb21wb25lbnRzLiBXaWxsIGJlIG51bGwgZm9yIGlubGluZSB2aWV3cy5cbiAgICovXG4gIHRlbXBsYXRlOiBDb21wb25lbnRUZW1wbGF0ZTx7fT58bnVsbDtcblxuICAvKipcbiAgICogQSBmdW5jdGlvbiBjb250YWluaW5nIHF1ZXJ5LXJlbGF0ZWQgaW5zdHJ1Y3Rpb25zLlxuICAgKi9cbiAgdmlld1F1ZXJ5OiBWaWV3UXVlcmllc0Z1bmN0aW9uPHt9PnxudWxsO1xuXG4gIC8qKlxuICAgKiBBIGBUTm9kZWAgcmVwcmVzZW50aW5nIHRoZSBkZWNsYXJhdGlvbiBsb2NhdGlvbiBvZiB0aGlzIGBUVmlld2AgKG5vdCBwYXJ0IG9mIHRoaXMgVFZpZXcpLlxuICAgKi9cbiAgZGVjbFROb2RlOiBUTm9kZXxudWxsO1xuXG4gIC8vIEZJWE1FKG1pc2tvKTogV2h5IGRvZXMgYFRWaWV3YCBub3QgaGF2ZSBgZGVjbGFyYXRpb25UVmlld2AgcHJvcGVydHk/XG5cbiAgLyoqIFdoZXRoZXIgb3Igbm90IHRoaXMgdGVtcGxhdGUgaGFzIGJlZW4gcHJvY2Vzc2VkIGluIGNyZWF0aW9uIG1vZGUuICovXG4gIGZpcnN0Q3JlYXRlUGFzczogYm9vbGVhbjtcblxuICAvKipcbiAgICogIFdoZXRoZXIgb3Igbm90IHRoaXMgdGVtcGxhdGUgaGFzIGJlZW4gcHJvY2Vzc2VkIGluIHVwZGF0ZSBtb2RlIChlLmcuIGNoYW5nZSBkZXRlY3RlZClcbiAgICpcbiAgICogYGZpcnN0VXBkYXRlUGFzc2AgaXMgdXNlZCBieSBzdHlsaW5nIHRvIHNldCB1cCBgVERhdGFgIHRvIGNvbnRhaW4gbWV0YWRhdGEgYWJvdXQgdGhlIHN0eWxpbmdcbiAgICogaW5zdHJ1Y3Rpb25zLiAoTWFpbmx5IHRvIGJ1aWxkIHVwIGEgbGlua2VkIGxpc3Qgb2Ygc3R5bGluZyBwcmlvcml0eSBvcmRlci4pXG4gICAqXG4gICAqIFR5cGljYWxseSB0aGlzIGZ1bmN0aW9uIGdldHMgY2xlYXJlZCBhZnRlciBmaXJzdCBleGVjdXRpb24uIElmIGV4Y2VwdGlvbiBpcyB0aHJvd24gdGhlbiB0aGlzXG4gICAqIGZsYWcgY2FuIHJlbWFpbiB0dXJuZWQgdW4gdW50aWwgdGhlcmUgaXMgZmlyc3Qgc3VjY2Vzc2Z1bCAobm8gZXhjZXB0aW9uKSBwYXNzLiBUaGlzIG1lYW5zIHRoYXRcbiAgICogaW5kaXZpZHVhbCBzdHlsaW5nIGluc3RydWN0aW9ucyBrZWVwIHRyYWNrIG9mIGlmIHRoZXkgaGF2ZSBhbHJlYWR5IGJlZW4gYWRkZWQgdG8gdGhlIGxpbmtlZFxuICAgKiBsaXN0IHRvIHByZXZlbnQgZG91YmxlIGFkZGluZy5cbiAgICovXG4gIGZpcnN0VXBkYXRlUGFzczogYm9vbGVhbjtcblxuICAvKiogU3RhdGljIGRhdGEgZXF1aXZhbGVudCBvZiBMVmlldy5kYXRhW10uIENvbnRhaW5zIFROb2RlcywgUGlwZURlZkludGVybmFsIG9yIFRJMThuLiAqL1xuICBkYXRhOiBURGF0YTtcblxuICAvKipcbiAgICogVGhlIGJpbmRpbmcgc3RhcnQgaW5kZXggaXMgdGhlIGluZGV4IGF0IHdoaWNoIHRoZSBkYXRhIGFycmF5XG4gICAqIHN0YXJ0cyB0byBzdG9yZSBiaW5kaW5ncyBvbmx5LiBTYXZpbmcgdGhpcyB2YWx1ZSBlbnN1cmVzIHRoYXQgd2VcbiAgICogd2lsbCBiZWdpbiByZWFkaW5nIGJpbmRpbmdzIGF0IHRoZSBjb3JyZWN0IHBvaW50IGluIHRoZSBhcnJheSB3aGVuXG4gICAqIHdlIGFyZSBpbiB1cGRhdGUgbW9kZS5cbiAgICpcbiAgICogLTEgbWVhbnMgdGhhdCBpdCBoYXMgbm90IGJlZW4gaW5pdGlhbGl6ZWQuXG4gICAqL1xuICBiaW5kaW5nU3RhcnRJbmRleDogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgaW5kZXggd2hlcmUgdGhlIFwiZXhwYW5kb1wiIHNlY3Rpb24gb2YgYExWaWV3YCBiZWdpbnMuIFRoZSBleHBhbmRvXG4gICAqIHNlY3Rpb24gY29udGFpbnMgaW5qZWN0b3JzLCBkaXJlY3RpdmUgaW5zdGFuY2VzLCBhbmQgaG9zdCBiaW5kaW5nIHZhbHVlcy5cbiAgICogVW5saWtlIHRoZSBcImRlY2xzXCIgYW5kIFwidmFyc1wiIHNlY3Rpb25zIG9mIGBMVmlld2AsIHRoZSBsZW5ndGggb2YgdGhpc1xuICAgKiBzZWN0aW9uIGNhbm5vdCBiZSBjYWxjdWxhdGVkIGF0IGNvbXBpbGUtdGltZSBiZWNhdXNlIGRpcmVjdGl2ZXMgYXJlIG1hdGNoZWRcbiAgICogYXQgcnVudGltZSB0byBwcmVzZXJ2ZSBsb2NhbGl0eS5cbiAgICpcbiAgICogV2Ugc3RvcmUgdGhpcyBzdGFydCBpbmRleCBzbyB3ZSBrbm93IHdoZXJlIHRvIHN0YXJ0IGNoZWNraW5nIGhvc3QgYmluZGluZ3NcbiAgICogaW4gYHNldEhvc3RCaW5kaW5nc2AuXG4gICAqL1xuICBleHBhbmRvU3RhcnRJbmRleDogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIG9yIG5vdCB0aGVyZSBhcmUgYW55IHN0YXRpYyB2aWV3IHF1ZXJpZXMgdHJhY2tlZCBvbiB0aGlzIHZpZXcuXG4gICAqXG4gICAqIFdlIHN0b3JlIHRoaXMgc28gd2Uga25vdyB3aGV0aGVyIG9yIG5vdCB3ZSBzaG91bGQgZG8gYSB2aWV3IHF1ZXJ5XG4gICAqIHJlZnJlc2ggYWZ0ZXIgY3JlYXRpb24gbW9kZSB0byBjb2xsZWN0IHN0YXRpYyBxdWVyeSByZXN1bHRzLlxuICAgKi9cbiAgc3RhdGljVmlld1F1ZXJpZXM6IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IHRoZXJlIGFyZSBhbnkgc3RhdGljIGNvbnRlbnQgcXVlcmllcyB0cmFja2VkIG9uIHRoaXMgdmlldy5cbiAgICpcbiAgICogV2Ugc3RvcmUgdGhpcyBzbyB3ZSBrbm93IHdoZXRoZXIgb3Igbm90IHdlIHNob3VsZCBkbyBhIGNvbnRlbnQgcXVlcnlcbiAgICogcmVmcmVzaCBhZnRlciBjcmVhdGlvbiBtb2RlIHRvIGNvbGxlY3Qgc3RhdGljIHF1ZXJ5IHJlc3VsdHMuXG4gICAqL1xuICBzdGF0aWNDb250ZW50UXVlcmllczogYm9vbGVhbjtcblxuICAvKipcbiAgICogQSByZWZlcmVuY2UgdG8gdGhlIGZpcnN0IGNoaWxkIG5vZGUgbG9jYXRlZCBpbiB0aGUgdmlldy5cbiAgICovXG4gIGZpcnN0Q2hpbGQ6IFROb2RlfG51bGw7XG5cbiAgLyoqXG4gICAqIFN0b3JlcyB0aGUgT3BDb2RlcyB0byBiZSByZXBsYXllZCBkdXJpbmcgY2hhbmdlLWRldGVjdGlvbiB0byBwcm9jZXNzIHRoZSBgSG9zdEJpbmRpbmdzYFxuICAgKlxuICAgKiBTZWUgYEhvc3RCaW5kaW5nT3BDb2Rlc2AgZm9yIGVuY29kaW5nIGRldGFpbHMuXG4gICAqL1xuICBob3N0QmluZGluZ09wQ29kZXM6IEhvc3RCaW5kaW5nT3BDb2Rlc3xudWxsO1xuXG4gIC8qKlxuICAgKiBGdWxsIHJlZ2lzdHJ5IG9mIGRpcmVjdGl2ZXMgYW5kIGNvbXBvbmVudHMgdGhhdCBtYXkgYmUgZm91bmQgaW4gdGhpcyB2aWV3LlxuICAgKlxuICAgKiBJdCdzIG5lY2Vzc2FyeSB0byBrZWVwIGEgY29weSBvZiB0aGUgZnVsbCBkZWYgbGlzdCBvbiB0aGUgVFZpZXcgc28gaXQncyBwb3NzaWJsZVxuICAgKiB0byByZW5kZXIgdGVtcGxhdGUgZnVuY3Rpb25zIHdpdGhvdXQgYSBob3N0IGNvbXBvbmVudC5cbiAgICovXG4gIGRpcmVjdGl2ZVJlZ2lzdHJ5OiBEaXJlY3RpdmVEZWZMaXN0fG51bGw7XG5cbiAgLyoqXG4gICAqIEZ1bGwgcmVnaXN0cnkgb2YgcGlwZXMgdGhhdCBtYXkgYmUgZm91bmQgaW4gdGhpcyB2aWV3LlxuICAgKlxuICAgKiBUaGUgcHJvcGVydHkgaXMgZWl0aGVyIGFuIGFycmF5IG9mIGBQaXBlRGVmc2BzIG9yIGEgZnVuY3Rpb24gd2hpY2ggcmV0dXJucyB0aGUgYXJyYXkgb2ZcbiAgICogYFBpcGVEZWZzYHMuIFRoZSBmdW5jdGlvbiBpcyBuZWNlc3NhcnkgdG8gYmUgYWJsZSB0byBzdXBwb3J0IGZvcndhcmQgZGVjbGFyYXRpb25zLlxuICAgKlxuICAgKiBJdCdzIG5lY2Vzc2FyeSB0byBrZWVwIGEgY29weSBvZiB0aGUgZnVsbCBkZWYgbGlzdCBvbiB0aGUgVFZpZXcgc28gaXQncyBwb3NzaWJsZVxuICAgKiB0byByZW5kZXIgdGVtcGxhdGUgZnVuY3Rpb25zIHdpdGhvdXQgYSBob3N0IGNvbXBvbmVudC5cbiAgICovXG4gIHBpcGVSZWdpc3RyeTogUGlwZURlZkxpc3R8bnVsbDtcblxuICAvKipcbiAgICogQXJyYXkgb2YgbmdPbkluaXQsIG5nT25DaGFuZ2VzIGFuZCBuZ0RvQ2hlY2sgaG9va3MgdGhhdCBzaG91bGQgYmUgZXhlY3V0ZWQgZm9yIHRoaXMgdmlldyBpblxuICAgKiBjcmVhdGlvbiBtb2RlLlxuICAgKlxuICAgKiBUaGlzIGFycmF5IGhhcyBhIGZsYXQgc3RydWN0dXJlIGFuZCBjb250YWlucyBUTm9kZSBpbmRpY2VzLCBkaXJlY3RpdmUgaW5kaWNlcyAod2hlcmUgYW5cbiAgICogaW5zdGFuY2UgY2FuIGJlIGZvdW5kIGluIGBMVmlld2ApIGFuZCBob29rIGZ1bmN0aW9ucy4gVE5vZGUgaW5kZXggaXMgZm9sbG93ZWQgYnkgdGhlIGRpcmVjdGl2ZVxuICAgKiBpbmRleCBhbmQgYSBob29rIGZ1bmN0aW9uLiBJZiB0aGVyZSBhcmUgbXVsdGlwbGUgaG9va3MgZm9yIGEgZ2l2ZW4gVE5vZGUsIHRoZSBUTm9kZSBpbmRleCBpc1xuICAgKiBub3QgcmVwZWF0ZWQgYW5kIHRoZSBuZXh0IGxpZmVjeWNsZSBob29rIGluZm9ybWF0aW9uIGlzIHN0b3JlZCByaWdodCBhZnRlciB0aGUgcHJldmlvdXMgaG9va1xuICAgKiBmdW5jdGlvbi4gVGhpcyBpcyBkb25lIHNvIHRoYXQgYXQgcnVudGltZSB0aGUgc3lzdGVtIGNhbiBlZmZpY2llbnRseSBpdGVyYXRlIG92ZXIgYWxsIG9mIHRoZVxuICAgKiBmdW5jdGlvbnMgdG8gaW52b2tlIHdpdGhvdXQgaGF2aW5nIHRvIG1ha2UgYW55IGRlY2lzaW9ucy9sb29rdXBzLlxuICAgKi9cbiAgcHJlT3JkZXJIb29rczogSG9va0RhdGF8bnVsbDtcblxuICAvKipcbiAgICogQXJyYXkgb2YgbmdPbkNoYW5nZXMgYW5kIG5nRG9DaGVjayBob29rcyB0aGF0IHNob3VsZCBiZSBleGVjdXRlZCBmb3IgdGhpcyB2aWV3IGluIHVwZGF0ZSBtb2RlLlxuICAgKlxuICAgKiBUaGlzIGFycmF5IGhhcyB0aGUgc2FtZSBzdHJ1Y3R1cmUgYXMgdGhlIGBwcmVPcmRlckhvb2tzYCBvbmUuXG4gICAqL1xuICBwcmVPcmRlckNoZWNrSG9va3M6IEhvb2tEYXRhfG51bGw7XG5cbiAgLyoqXG4gICAqIEFycmF5IG9mIG5nQWZ0ZXJDb250ZW50SW5pdCBhbmQgbmdBZnRlckNvbnRlbnRDaGVja2VkIGhvb2tzIHRoYXQgc2hvdWxkIGJlIGV4ZWN1dGVkXG4gICAqIGZvciB0aGlzIHZpZXcgaW4gY3JlYXRpb24gbW9kZS5cbiAgICpcbiAgICogRXZlbiBpbmRpY2VzOiBEaXJlY3RpdmUgaW5kZXhcbiAgICogT2RkIGluZGljZXM6IEhvb2sgZnVuY3Rpb25cbiAgICovXG4gIGNvbnRlbnRIb29rczogSG9va0RhdGF8bnVsbDtcblxuICAvKipcbiAgICogQXJyYXkgb2YgbmdBZnRlckNvbnRlbnRDaGVja2VkIGhvb2tzIHRoYXQgc2hvdWxkIGJlIGV4ZWN1dGVkIGZvciB0aGlzIHZpZXcgaW4gdXBkYXRlXG4gICAqIG1vZGUuXG4gICAqXG4gICAqIEV2ZW4gaW5kaWNlczogRGlyZWN0aXZlIGluZGV4XG4gICAqIE9kZCBpbmRpY2VzOiBIb29rIGZ1bmN0aW9uXG4gICAqL1xuICBjb250ZW50Q2hlY2tIb29rczogSG9va0RhdGF8bnVsbDtcblxuICAvKipcbiAgICogQXJyYXkgb2YgbmdBZnRlclZpZXdJbml0IGFuZCBuZ0FmdGVyVmlld0NoZWNrZWQgaG9va3MgdGhhdCBzaG91bGQgYmUgZXhlY3V0ZWQgZm9yXG4gICAqIHRoaXMgdmlldyBpbiBjcmVhdGlvbiBtb2RlLlxuICAgKlxuICAgKiBFdmVuIGluZGljZXM6IERpcmVjdGl2ZSBpbmRleFxuICAgKiBPZGQgaW5kaWNlczogSG9vayBmdW5jdGlvblxuICAgKi9cbiAgdmlld0hvb2tzOiBIb29rRGF0YXxudWxsO1xuXG4gIC8qKlxuICAgKiBBcnJheSBvZiBuZ0FmdGVyVmlld0NoZWNrZWQgaG9va3MgdGhhdCBzaG91bGQgYmUgZXhlY3V0ZWQgZm9yIHRoaXMgdmlldyBpblxuICAgKiB1cGRhdGUgbW9kZS5cbiAgICpcbiAgICogRXZlbiBpbmRpY2VzOiBEaXJlY3RpdmUgaW5kZXhcbiAgICogT2RkIGluZGljZXM6IEhvb2sgZnVuY3Rpb25cbiAgICovXG4gIHZpZXdDaGVja0hvb2tzOiBIb29rRGF0YXxudWxsO1xuXG4gIC8qKlxuICAgKiBBcnJheSBvZiBuZ09uRGVzdHJveSBob29rcyB0aGF0IHNob3VsZCBiZSBleGVjdXRlZCB3aGVuIHRoaXMgdmlldyBpcyBkZXN0cm95ZWQuXG4gICAqXG4gICAqIEV2ZW4gaW5kaWNlczogRGlyZWN0aXZlIGluZGV4XG4gICAqIE9kZCBpbmRpY2VzOiBIb29rIGZ1bmN0aW9uXG4gICAqL1xuICBkZXN0cm95SG9va3M6IERlc3Ryb3lIb29rRGF0YXxudWxsO1xuXG4gIC8qKlxuICAgKiBXaGVuIGEgdmlldyBpcyBkZXN0cm95ZWQsIGxpc3RlbmVycyBuZWVkIHRvIGJlIHJlbGVhc2VkIGFuZCBvdXRwdXRzIG5lZWQgdG8gYmVcbiAgICogdW5zdWJzY3JpYmVkLiBUaGlzIGNsZWFudXAgYXJyYXkgc3RvcmVzIGJvdGggbGlzdGVuZXIgZGF0YSAoaW4gY2h1bmtzIG9mIDQpXG4gICAqIGFuZCBvdXRwdXQgZGF0YSAoaW4gY2h1bmtzIG9mIDIpIGZvciBhIHBhcnRpY3VsYXIgdmlldy4gQ29tYmluaW5nIHRoZSBhcnJheXNcbiAgICogc2F2ZXMgb24gbWVtb3J5ICg3MCBieXRlcyBwZXIgYXJyYXkpIGFuZCBvbiBhIGZldyBieXRlcyBvZiBjb2RlIHNpemUgKGZvciB0d29cbiAgICogc2VwYXJhdGUgZm9yIGxvb3BzKS5cbiAgICpcbiAgICogSWYgaXQncyBhIG5hdGl2ZSBET00gbGlzdGVuZXIgb3Igb3V0cHV0IHN1YnNjcmlwdGlvbiBiZWluZyBzdG9yZWQ6XG4gICAqIDFzdCBpbmRleCBpczogZXZlbnQgbmFtZSAgYG5hbWUgPSB0Vmlldy5jbGVhbnVwW2krMF1gXG4gICAqIDJuZCBpbmRleCBpczogaW5kZXggb2YgbmF0aXZlIGVsZW1lbnQgb3IgYSBmdW5jdGlvbiB0aGF0IHJldHJpZXZlcyBnbG9iYWwgdGFyZ2V0ICh3aW5kb3csXG4gICAqICAgICAgICAgICAgICAgZG9jdW1lbnQgb3IgYm9keSkgcmVmZXJlbmNlIGJhc2VkIG9uIHRoZSBuYXRpdmUgZWxlbWVudDpcbiAgICogICAgYHR5cGVvZiBpZHhPclRhcmdldEdldHRlciA9PT0gJ2Z1bmN0aW9uJ2A6IGdsb2JhbCB0YXJnZXQgZ2V0dGVyIGZ1bmN0aW9uXG4gICAqICAgIGB0eXBlb2YgaWR4T3JUYXJnZXRHZXR0ZXIgPT09ICdudW1iZXInYDogaW5kZXggb2YgbmF0aXZlIGVsZW1lbnRcbiAgICpcbiAgICogM3JkIGluZGV4IGlzOiBpbmRleCBvZiBsaXN0ZW5lciBmdW5jdGlvbiBgbGlzdGVuZXIgPSBsVmlld1tDTEVBTlVQXVt0Vmlldy5jbGVhbnVwW2krMl1dYFxuICAgKiA0dGggaW5kZXggaXM6IGB1c2VDYXB0dXJlT3JJbmR4ID0gdFZpZXcuY2xlYW51cFtpKzNdYFxuICAgKiAgICBgdHlwZW9mIHVzZUNhcHR1cmVPckluZHggPT0gJ2Jvb2xlYW4nIDogdXNlQ2FwdHVyZSBib29sZWFuXG4gICAqICAgIGB0eXBlb2YgdXNlQ2FwdHVyZU9ySW5keCA9PSAnbnVtYmVyJzpcbiAgICogICAgICAgICBgdXNlQ2FwdHVyZU9ySW5keCA+PSAwYCBgcmVtb3ZlTGlzdGVuZXIgPSBMVmlld1tDTEVBTlVQXVt1c2VDYXB0dXJlT3JJbmR4XWBcbiAgICogICAgICAgICBgdXNlQ2FwdHVyZU9ySW5keCA8ICAwYCBgc3Vic2NyaXB0aW9uID0gTFZpZXdbQ0xFQU5VUF1bLXVzZUNhcHR1cmVPckluZHhdYFxuICAgKlxuICAgKiBJZiBpdCdzIGFuIG91dHB1dCBzdWJzY3JpcHRpb24gb3IgcXVlcnkgbGlzdCBkZXN0cm95IGhvb2s6XG4gICAqIDFzdCBpbmRleCBpczogb3V0cHV0IHVuc3Vic2NyaWJlIGZ1bmN0aW9uIC8gcXVlcnkgbGlzdCBkZXN0cm95IGZ1bmN0aW9uXG4gICAqIDJuZCBpbmRleCBpczogaW5kZXggb2YgZnVuY3Rpb24gY29udGV4dCBpbiBMVmlldy5jbGVhbnVwSW5zdGFuY2VzW11cbiAgICogICAgICAgICAgICAgICBgdFZpZXcuY2xlYW51cFtpKzBdLmNhbGwobFZpZXdbQ0xFQU5VUF1bdFZpZXcuY2xlYW51cFtpKzFdXSlgXG4gICAqL1xuICBjbGVhbnVwOiBhbnlbXXxudWxsO1xuXG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgZWxlbWVudCBpbmRpY2VzIGZvciBjaGlsZCBjb21wb25lbnRzIHRoYXQgd2lsbCBuZWVkIHRvIGJlXG4gICAqIHJlZnJlc2hlZCB3aGVuIHRoZSBjdXJyZW50IHZpZXcgaGFzIGZpbmlzaGVkIGl0cyBjaGVjay4gVGhlc2UgaW5kaWNlcyBoYXZlXG4gICAqIGFscmVhZHkgYmVlbiBhZGp1c3RlZCBmb3IgdGhlIEhFQURFUl9PRkZTRVQuXG4gICAqXG4gICAqL1xuICBjb21wb25lbnRzOiBudW1iZXJbXXxudWxsO1xuXG4gIC8qKlxuICAgKiBBIGNvbGxlY3Rpb24gb2YgcXVlcmllcyB0cmFja2VkIGluIGEgZ2l2ZW4gdmlldy5cbiAgICovXG4gIHF1ZXJpZXM6IFRRdWVyaWVzfG51bGw7XG5cbiAgLyoqXG4gICAqIEFuIGFycmF5IG9mIGluZGljZXMgcG9pbnRpbmcgdG8gZGlyZWN0aXZlcyB3aXRoIGNvbnRlbnQgcXVlcmllcyBhbG9uZ3NpZGUgd2l0aCB0aGVcbiAgICogY29ycmVzcG9uZGluZyBxdWVyeSBpbmRleC4gRWFjaCBlbnRyeSBpbiB0aGlzIGFycmF5IGlzIGEgdHVwbGUgb2Y6XG4gICAqIC0gaW5kZXggb2YgdGhlIGZpcnN0IGNvbnRlbnQgcXVlcnkgaW5kZXggZGVjbGFyZWQgYnkgYSBnaXZlbiBkaXJlY3RpdmU7XG4gICAqIC0gaW5kZXggb2YgYSBkaXJlY3RpdmUuXG4gICAqXG4gICAqIFdlIGFyZSBzdG9yaW5nIHRob3NlIGluZGV4ZXMgc28gd2UgY2FuIHJlZnJlc2ggY29udGVudCBxdWVyaWVzIGFzIHBhcnQgb2YgYSB2aWV3IHJlZnJlc2hcbiAgICogcHJvY2Vzcy5cbiAgICovXG4gIGNvbnRlbnRRdWVyaWVzOiBudW1iZXJbXXxudWxsO1xuXG4gIC8qKlxuICAgKiBTZXQgb2Ygc2NoZW1hcyB0aGF0IGRlY2xhcmUgZWxlbWVudHMgdG8gYmUgYWxsb3dlZCBpbnNpZGUgdGhlIHZpZXcuXG4gICAqL1xuICBzY2hlbWFzOiBTY2hlbWFNZXRhZGF0YVtdfG51bGw7XG5cbiAgLyoqXG4gICAqIEFycmF5IG9mIGNvbnN0YW50cyBmb3IgdGhlIHZpZXcuIEluY2x1ZGVzIGF0dHJpYnV0ZSBhcnJheXMsIGxvY2FsIGRlZmluaXRpb24gYXJyYXlzIGV0Yy5cbiAgICogVXNlZCBmb3IgZGlyZWN0aXZlIG1hdGNoaW5nLCBhdHRyaWJ1dGUgYmluZGluZ3MsIGxvY2FsIGRlZmluaXRpb25zIGFuZCBtb3JlLlxuICAgKi9cbiAgY29uc3RzOiBUQ29uc3RhbnRzfG51bGw7XG5cbiAgLyoqXG4gICAqIEluZGljYXRlcyB0aGF0IHRoZXJlIHdhcyBhbiBlcnJvciBiZWZvcmUgd2UgbWFuYWdlZCB0byBjb21wbGV0ZSB0aGUgZmlyc3QgY3JlYXRlIHBhc3Mgb2YgdGhlXG4gICAqIHZpZXcuIFRoaXMgbWVhbnMgdGhhdCB0aGUgdmlldyBpcyBsaWtlbHkgY29ycnVwdGVkIGFuZCB3ZSBzaG91bGQgdHJ5IHRvIHJlY292ZXIgaXQuXG4gICAqL1xuICBpbmNvbXBsZXRlRmlyc3RQYXNzOiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBVbmlxdWUgaWQgb2YgdGhpcyBUVmlldyBmb3IgaHlkcmF0aW9uIHB1cnBvc2VzOlxuICAgKiAtIFRWaWV3VHlwZS5FbWJlZGRlZDogYSB1bmlxdWUgaWQgZ2VuZXJhdGVkIGR1cmluZyBzZXJpYWxpemF0aW9uIG9uIHRoZSBzZXJ2ZXJcbiAgICogLSBUVmlld1R5cGUuQ29tcG9uZW50OiBhbiBpZCBnZW5lcmF0ZWQgYmFzZWQgb24gY29tcG9uZW50IHByb3BlcnRpZXNcbiAgICogICAgICAgICAgICAgICAgICAgICAgICAoc2VlIGBnZXRDb21wb25lbnRJZGAgZnVuY3Rpb24gZm9yIGRldGFpbHMpXG4gICAqL1xuICBzc3JJZDogc3RyaW5nfG51bGw7XG59XG5cbi8qKiBTaW5nbGUgaG9vayBjYWxsYmFjayBmdW5jdGlvbi4gKi9cbmV4cG9ydCB0eXBlIEhvb2tGbiA9ICgpID0+IHZvaWQ7XG5cbi8qKlxuICogSW5mb3JtYXRpb24gbmVjZXNzYXJ5IHRvIGNhbGwgYSBob29rLiBFLmcuIHRoZSBjYWxsYmFjayB0aGF0XG4gKiBuZWVkcyB0byBpbnZva2VkIGFuZCB0aGUgaW5kZXggYXQgd2hpY2ggdG8gZmluZCBpdHMgY29udGV4dC5cbiAqL1xuZXhwb3J0IHR5cGUgSG9va0VudHJ5ID0gbnVtYmVyfEhvb2tGbjtcblxuLyoqXG4gKiBBcnJheSBvZiBob29rcyB0aGF0IHNob3VsZCBiZSBleGVjdXRlZCBmb3IgYSB2aWV3IGFuZCB0aGVpciBkaXJlY3RpdmUgaW5kaWNlcy5cbiAqXG4gKiBGb3IgZWFjaCBub2RlIG9mIHRoZSB2aWV3LCB0aGUgZm9sbG93aW5nIGRhdGEgaXMgc3RvcmVkOlxuICogMSkgTm9kZSBpbmRleCAob3B0aW9uYWwpXG4gKiAyKSBBIHNlcmllcyBvZiBudW1iZXIvZnVuY3Rpb24gcGFpcnMgd2hlcmU6XG4gKiAgLSBldmVuIGluZGljZXMgYXJlIGRpcmVjdGl2ZSBpbmRpY2VzXG4gKiAgLSBvZGQgaW5kaWNlcyBhcmUgaG9vayBmdW5jdGlvbnNcbiAqXG4gKiBTcGVjaWFsIGNhc2VzOlxuICogIC0gYSBuZWdhdGl2ZSBkaXJlY3RpdmUgaW5kZXggZmxhZ3MgYW4gaW5pdCBob29rIChuZ09uSW5pdCwgbmdBZnRlckNvbnRlbnRJbml0LCBuZ0FmdGVyVmlld0luaXQpXG4gKi9cbmV4cG9ydCB0eXBlIEhvb2tEYXRhID0gSG9va0VudHJ5W107XG5cbi8qKlxuICogQXJyYXkgb2YgZGVzdHJveSBob29rcyB0aGF0IHNob3VsZCBiZSBleGVjdXRlZCBmb3IgYSB2aWV3IGFuZCB0aGVpciBkaXJlY3RpdmUgaW5kaWNlcy5cbiAqXG4gKiBUaGUgYXJyYXkgaXMgc2V0IHVwIGFzIGEgc2VyaWVzIG9mIG51bWJlci9mdW5jdGlvbiBvciBudW1iZXIvKG51bWJlcnxmdW5jdGlvbilbXTpcbiAqIC0gRXZlbiBpbmRpY2VzIHJlcHJlc2VudCB0aGUgY29udGV4dCB3aXRoIHdoaWNoIGhvb2tzIHNob3VsZCBiZSBjYWxsZWQuXG4gKiAtIE9kZCBpbmRpY2VzIGFyZSB0aGUgaG9vayBmdW5jdGlvbnMgdGhlbXNlbHZlcy4gSWYgYSB2YWx1ZSBhdCBhbiBvZGQgaW5kZXggaXMgYW4gYXJyYXksXG4gKiAgIGl0IHJlcHJlc2VudHMgdGhlIGRlc3Ryb3kgaG9va3Mgb2YgYSBgbXVsdGlgIHByb3ZpZGVyIHdoZXJlOlxuICogICAgIC0gRXZlbiBpbmRpY2VzIHJlcHJlc2VudCB0aGUgaW5kZXggb2YgdGhlIHByb3ZpZGVyIGZvciB3aGljaCB3ZSd2ZSByZWdpc3RlcmVkIGEgZGVzdHJveSBob29rLFxuICogICAgICAgaW5zaWRlIG9mIHRoZSBgbXVsdGlgIHByb3ZpZGVyIGFycmF5LlxuICogICAgIC0gT2RkIGluZGljZXMgYXJlIHRoZSBkZXN0cm95IGhvb2sgZnVuY3Rpb25zLlxuICogRm9yIGV4YW1wbGU6XG4gKiBMVmlldzogYFswLCAxLCAyLCBBU2VydmljZSwgNCwgW0JTZXJ2aWNlLCBDU2VydmljZSwgRFNlcnZpY2VdXWBcbiAqIGRlc3Ryb3lIb29rczogYFszLCBBU2VydmljZS5uZ09uRGVzdHJveSwgNSwgWzAsIEJTZXJ2aWNlLm5nT25EZXN0cm95LCAyLCBEU2VydmljZS5uZ09uRGVzdHJveV1dYFxuICpcbiAqIEluIHRoZSBleGFtcGxlIGFib3ZlIGBBU2VydmljZWAgaXMgYSB0eXBlIHByb3ZpZGVyIHdpdGggYW4gYG5nT25EZXN0cm95YCwgd2hlcmVhcyBgQlNlcnZpY2VgLFxuICogYENTZXJ2aWNlYCBhbmQgYERTZXJ2aWNlYCBhcmUgcGFydCBvZiBhIGBtdWx0aWAgcHJvdmlkZXIgd2hlcmUgb25seSBgQlNlcnZpY2VgIGFuZCBgRFNlcnZpY2VgXG4gKiBoYXZlIGFuIGBuZ09uRGVzdHJveWAgaG9vay5cbiAqL1xuZXhwb3J0IHR5cGUgRGVzdHJveUhvb2tEYXRhID0gKEhvb2tFbnRyeXxIb29rRGF0YSlbXTtcblxuLyoqXG4gKiBTdGF0aWMgZGF0YSB0aGF0IGNvcnJlc3BvbmRzIHRvIHRoZSBpbnN0YW5jZS1zcGVjaWZpYyBkYXRhIGFycmF5IG9uIGFuIExWaWV3LlxuICpcbiAqIEVhY2ggbm9kZSdzIHN0YXRpYyBkYXRhIGlzIHN0b3JlZCBpbiB0RGF0YSBhdCB0aGUgc2FtZSBpbmRleCB0aGF0IGl0J3Mgc3RvcmVkXG4gKiBpbiB0aGUgZGF0YSBhcnJheS4gIEFueSBub2RlcyB0aGF0IGRvIG5vdCBoYXZlIHN0YXRpYyBkYXRhIHN0b3JlIGEgbnVsbCB2YWx1ZSBpblxuICogdERhdGEgdG8gYXZvaWQgYSBzcGFyc2UgYXJyYXkuXG4gKlxuICogRWFjaCBwaXBlJ3MgZGVmaW5pdGlvbiBpcyBzdG9yZWQgaGVyZSBhdCB0aGUgc2FtZSBpbmRleCBhcyBpdHMgcGlwZSBpbnN0YW5jZSBpblxuICogdGhlIGRhdGEgYXJyYXkuXG4gKlxuICogRWFjaCBob3N0IHByb3BlcnR5J3MgbmFtZSBpcyBzdG9yZWQgaGVyZSBhdCB0aGUgc2FtZSBpbmRleCBhcyBpdHMgdmFsdWUgaW4gdGhlXG4gKiBkYXRhIGFycmF5LlxuICpcbiAqIEVhY2ggcHJvcGVydHkgYmluZGluZyBuYW1lIGlzIHN0b3JlZCBoZXJlIGF0IHRoZSBzYW1lIGluZGV4IGFzIGl0cyB2YWx1ZSBpblxuICogdGhlIGRhdGEgYXJyYXkuIElmIHRoZSBiaW5kaW5nIGlzIGFuIGludGVycG9sYXRpb24sIHRoZSBzdGF0aWMgc3RyaW5nIHZhbHVlc1xuICogYXJlIHN0b3JlZCBwYXJhbGxlbCB0byB0aGUgZHluYW1pYyB2YWx1ZXMuIEV4YW1wbGU6XG4gKlxuICogaWQ9XCJwcmVmaXgge3sgdjAgfX0gYSB7eyB2MSB9fSBiIHt7IHYyIH19IHN1ZmZpeFwiXG4gKlxuICogTFZpZXcgICAgICAgfCAgIFRWaWV3LmRhdGFcbiAqLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gKiAgdjAgdmFsdWUgICB8ICAgJ2EnXG4gKiAgdjEgdmFsdWUgICB8ICAgJ2InXG4gKiAgdjIgdmFsdWUgICB8ICAgaWQg77+9IHByZWZpeCDvv70gc3VmZml4XG4gKlxuICogSW5qZWN0b3IgYmxvb20gZmlsdGVycyBhcmUgYWxzbyBzdG9yZWQgaGVyZS5cbiAqL1xuZXhwb3J0IHR5cGUgVERhdGEgPSAoVE5vZGV8UGlwZURlZjxhbnk+fERpcmVjdGl2ZURlZjxhbnk+fENvbXBvbmVudERlZjxhbnk+fG51bWJlcnxUU3R5bGluZ1JhbmdlfFxuICAgICAgICAgICAgICAgICAgICAgVFN0eWxpbmdLZXl8UHJvdmlkZXJUb2tlbjxhbnk+fFRJMThufEkxOG5VcGRhdGVPcENvZGVzfFRJY3V8bnVsbHxzdHJpbmcpW107XG5cbi8vIE5vdGU6IFRoaXMgaGFjayBpcyBuZWNlc3Nhcnkgc28gd2UgZG9uJ3QgZXJyb25lb3VzbHkgZ2V0IGEgY2lyY3VsYXIgZGVwZW5kZW5jeVxuLy8gZmFpbHVyZSBiYXNlZCBvbiB0eXBlcy5cbmV4cG9ydCBjb25zdCB1bnVzZWRWYWx1ZUV4cG9ydFRvUGxhY2F0ZUFqZCA9IDE7XG4iXX0=