/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { isUrlTree } from './url_tree';
export const NAVIGATION_CANCELING_ERROR = 'ngNavigationCancelingError';
export function redirectingNavigationError(urlSerializer, redirect) {
    const { redirectTo, navigationBehaviorOptions } = isUrlTree(redirect) ? { redirectTo: redirect, navigationBehaviorOptions: undefined } : redirect;
    const error = navigationCancelingError(ngDevMode && `Redirecting to "${urlSerializer.serialize(redirectTo)}"`, 0 /* NavigationCancellationCode.Redirect */, redirect);
    error.url = redirectTo;
    error.navigationBehaviorOptions = navigationBehaviorOptions;
    return error;
}
export function navigationCancelingError(message, code, redirectUrl) {
    const error = new Error('NavigationCancelingError: ' + (message || ''));
    error[NAVIGATION_CANCELING_ERROR] = true;
    error.cancellationCode = code;
    if (redirectUrl) {
        error.url = redirectUrl;
    }
    return error;
}
export function isRedirectingNavigationCancelingError(error) {
    return isNavigationCancelingError(error) && isUrlTree(error.url);
}
export function isNavigationCancelingError(error) {
    return error && error[NAVIGATION_CANCELING_ERROR];
}
//# sourceMappingURL=data:application/json;base64,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