"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const schematics_1 = require("@angular-devkit/schematics");
const parse_name_1 = require("@schematics/angular/utility/parse-name");
const validation_1 = require("@schematics/angular/utility/validation");
const workspace_1 = require("@schematics/angular/utility/workspace");
const util_1 = require("../util");
const route_utils_1 = require("./route-utils");
function default_1(options) {
    return async (host) => {
        var _a;
        if (!options.project) {
            throw new schematics_1.SchematicsException('Option (project) is required.');
        }
        const workspace = await (0, workspace_1.getWorkspace)(host);
        const project = workspace.projects.get(options.project);
        if (project && options.path === undefined) {
            options.path = (0, workspace_1.buildDefaultPath)(project);
        }
        if (!options.standalone) {
            options.module = (0, route_utils_1.findRoutingModuleFromOptions)(host, options);
        }
        const parsedPath = (0, parse_name_1.parseName)(options.path, options.name);
        options.name = parsedPath.name;
        options.path = parsedPath.path;
        options.selector = options.selector ? options.selector : (0, util_1.buildSelector)(options, (_a = project === null || project === void 0 ? void 0 : project.prefix) !== null && _a !== void 0 ? _a : 'app');
        (0, validation_1.validateHtmlSelector)(options.selector);
        const templateSource = (0, schematics_1.apply)((0, schematics_1.url)('./files'), [
            options.spec ? (0, schematics_1.noop)() : (0, schematics_1.filter)((p) => !p.endsWith('.spec.ts')),
            options.standalone ? (0, schematics_1.filter)((p) => !p.endsWith('module.ts')) : (0, schematics_1.noop)(),
            (0, schematics_1.template)({
                ...core_1.strings,
                'if-flat': (s) => (options.flat ? '' : s),
                ...options,
            }),
            (0, schematics_1.move)(parsedPath.path),
        ]);
        return (0, schematics_1.chain)([
            (0, schematics_1.branchAndMerge)((0, schematics_1.chain)([options.standalone ? (0, route_utils_1.addRoute)(options) : (0, route_utils_1.addRouteToNgModule)(options), (0, schematics_1.mergeWith)(templateSource)])),
        ]);
    };
}
exports.default = default_1;
