import { raf } from '@ionic/angular/common';
import { setupConfig } from '@ionic/core';
import { applyPolyfills, defineCustomElements } from '@ionic/core/loader';
// TODO(FW-2827): types
export const appInitialize = (config, doc, zone) => {
    return () => {
        const win = doc.defaultView;
        if (win && typeof window !== 'undefined') {
            setupConfig({
                ...config,
                _zoneGate: (h) => zone.run(h),
            });
            const aelFn = '__zone_symbol__addEventListener' in doc.body ? '__zone_symbol__addEventListener' : 'addEventListener';
            return applyPolyfills().then(() => {
                return defineCustomElements(win, {
                    exclude: ['ion-tabs', 'ion-tab'],
                    syncQueue: true,
                    raf,
                    jmp: (h) => zone.runOutsideAngular(h),
                    ael(elm, eventName, cb, opts) {
                        elm[aelFn](eventName, cb, opts);
                    },
                    rel(elm, eventName, cb, opts) {
                        elm.removeEventListener(eventName, cb, opts);
                    },
                });
            });
        }
    };
};
//# sourceMappingURL=data:application/json;base64,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