import { Directive, HostListener } from '@angular/core';
import { NgControl } from '@angular/forms';
import { raf } from '../../utils/util';
import * as i0 from "@angular/core";
// TODO(FW-2827): types
export class ValueAccessor {
    constructor(injector, elementRef) {
        this.injector = injector;
        this.elementRef = elementRef;
        this.onChange = () => {
            /**/
        };
        this.onTouched = () => {
            /**/
        };
    }
    writeValue(value) {
        this.elementRef.nativeElement.value = this.lastValue = value;
        setIonicClasses(this.elementRef);
    }
    /**
     * Notifies the ControlValueAccessor of a change in the value of the control.
     *
     * This is called by each of the ValueAccessor directives when we want to update
     * the status and validity of the form control. For example with text components this
     * is called when the ionInput event is fired. For select components this is called
     * when the ionChange event is fired.
     *
     * This also updates the Ionic form status classes on the element.
     *
     * @param el The component element.
     * @param value The new value of the control.
     */
    handleValueChange(el, value) {
        if (el === this.elementRef.nativeElement) {
            if (value !== this.lastValue) {
                this.lastValue = value;
                this.onChange(value);
            }
            setIonicClasses(this.elementRef);
        }
    }
    _handleBlurEvent(el) {
        if (el === this.elementRef.nativeElement) {
            this.onTouched();
            setIonicClasses(this.elementRef);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.elementRef.nativeElement.disabled = isDisabled;
    }
    ngOnDestroy() {
        if (this.statusChanges) {
            this.statusChanges.unsubscribe();
        }
    }
    ngAfterViewInit() {
        let ngControl;
        try {
            ngControl = this.injector.get(NgControl);
        }
        catch {
            /* No FormControl or ngModel binding */
        }
        if (!ngControl) {
            return;
        }
        // Listen for changes in validity, disabled, or pending states
        if (ngControl.statusChanges) {
            this.statusChanges = ngControl.statusChanges.subscribe(() => setIonicClasses(this.elementRef));
        }
        /**
         * TODO FW-2787: Remove this in favor of https://github.com/angular/angular/issues/10887
         * whenever it is implemented.
         */
        const formControl = ngControl.control;
        if (formControl) {
            const methodsToPatch = ['markAsTouched', 'markAllAsTouched', 'markAsUntouched', 'markAsDirty', 'markAsPristine'];
            methodsToPatch.forEach((method) => {
                if (typeof formControl[method] !== 'undefined') {
                    const oldFn = formControl[method].bind(formControl);
                    formControl[method] = (...params) => {
                        oldFn(...params);
                        setIonicClasses(this.elementRef);
                    };
                }
            });
        }
    }
}
/** @nocollapse */ ValueAccessor.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: ValueAccessor, deps: [{ token: i0.Injector }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ ValueAccessor.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.12", type: ValueAccessor, host: { listeners: { "ionBlur": "_handleBlurEvent($event.target)" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: ValueAccessor, decorators: [{
            type: Directive
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.ElementRef }]; }, propDecorators: { _handleBlurEvent: [{
                type: HostListener,
                args: ['ionBlur', ['$event.target']]
            }] } });
export const setIonicClasses = (element) => {
    raf(() => {
        const input = element.nativeElement;
        const hasValue = input.value != null && input.value.toString().length > 0;
        const classes = getClasses(input);
        setClasses(input, classes);
        const item = input.closest('ion-item');
        if (item) {
            if (hasValue) {
                setClasses(item, [...classes, 'item-has-value']);
            }
            else {
                setClasses(item, classes);
            }
        }
    });
};
const getClasses = (element) => {
    const classList = element.classList;
    const classes = [];
    for (let i = 0; i < classList.length; i++) {
        const item = classList.item(i);
        if (item !== null && startsWith(item, 'ng-')) {
            classes.push(`ion-${item.substring(3)}`);
        }
    }
    return classes;
};
const setClasses = (element, classes) => {
    const classList = element.classList;
    classList.remove('ion-valid', 'ion-invalid', 'ion-touched', 'ion-untouched', 'ion-dirty', 'ion-pristine');
    classList.add(...classes);
};
const startsWith = (input, search) => {
    return input.substring(0, search.length) === search;
};
//# sourceMappingURL=data:application/json;base64,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