import { __decorate } from "tslib";
import { HostListener, Input, Optional, Directive } from '@angular/core';
import { ProxyCmp } from '../../utils/proxy';
import * as i0 from "@angular/core";
import * as i1 from "./router-outlet";
import * as i2 from "../../providers/nav-controller";
import * as i3 from "../../providers/config";
const BACK_BUTTON_INPUTS = ['color', 'defaultHref', 'disabled', 'icon', 'mode', 'routerAnimation', 'text', 'type'];
let IonBackButton = class IonBackButton {
    constructor(routerOutlet, navCtrl, config, r, z, c) {
        this.routerOutlet = routerOutlet;
        this.navCtrl = navCtrl;
        this.config = config;
        this.r = r;
        this.z = z;
        c.detach();
        this.el = this.r.nativeElement;
    }
    /**
     * @internal
     */
    onClick(ev) {
        const defaultHref = this.defaultHref || this.config.get('backButtonDefaultHref');
        if (this.routerOutlet?.canGoBack()) {
            this.navCtrl.setDirection('back', undefined, undefined, this.routerAnimation);
            this.routerOutlet.pop();
            ev.preventDefault();
        }
        else if (defaultHref != null) {
            this.navCtrl.navigateBack(defaultHref, { animation: this.routerAnimation });
            ev.preventDefault();
        }
    }
};
/** @nocollapse */ IonBackButton.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonBackButton, deps: [{ token: i1.IonRouterOutlet, optional: true }, { token: i2.NavController }, { token: i3.Config }, { token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ IonBackButton.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.12", type: IonBackButton, inputs: { color: "color", defaultHref: "defaultHref", disabled: "disabled", icon: "icon", mode: "mode", routerAnimation: "routerAnimation", text: "text", type: "type" }, host: { listeners: { "click": "onClick($event)" } }, ngImport: i0 });
IonBackButton = __decorate([
    ProxyCmp({
        inputs: BACK_BUTTON_INPUTS,
    })
], IonBackButton);
export { IonBackButton };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonBackButton, decorators: [{
            type: Directive,
            args: [{
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: BACK_BUTTON_INPUTS,
                }]
        }], ctorParameters: function () { return [{ type: i1.IonRouterOutlet, decorators: [{
                    type: Optional
                }] }, { type: i2.NavController }, { type: i3.Config }, { type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { defaultHref: [{
                type: Input
            }], routerAnimation: [{
                type: Input
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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