import { Directive, ElementRef, EventEmitter, HostListener, Output, ViewChild, } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../providers/nav-controller";
// eslint-disable-next-line @angular-eslint/directive-class-suffix
export class IonTabs {
    constructor(navCtrl) {
        this.navCtrl = navCtrl;
        /**
         * Emitted before the tab view is changed.
         */
        this.ionTabsWillChange = new EventEmitter();
        /**
         * Emitted after the tab view is changed.
         */
        this.ionTabsDidChange = new EventEmitter();
        this.tabBarSlot = 'bottom';
    }
    ngAfterContentInit() {
        this.detectSlotChanges();
    }
    ngAfterContentChecked() {
        this.detectSlotChanges();
    }
    /**
     * @internal
     */
    onStackWillChange({ enteringView, tabSwitch }) {
        const stackId = enteringView.stackId;
        if (tabSwitch && stackId !== undefined) {
            this.ionTabsWillChange.emit({ tab: stackId });
        }
    }
    /**
     * @internal
     */
    onStackDidChange({ enteringView, tabSwitch }) {
        const stackId = enteringView.stackId;
        if (tabSwitch && stackId !== undefined) {
            if (this.tabBar) {
                this.tabBar.selectedTab = stackId;
            }
            this.ionTabsDidChange.emit({ tab: stackId });
        }
    }
    /**
     * When a tab button is clicked, there are several scenarios:
     * 1. If the selected tab is currently active (the tab button has been clicked
     *    again), then it should go to the root view for that tab.
     *
     *   a. Get the saved root view from the router outlet. If the saved root view
     *      matches the tabRootUrl, set the route view to this view including the
     *      navigation extras.
     *   b. If the saved root view from the router outlet does
     *      not match, navigate to the tabRootUrl. No navigation extras are
     *      included.
     *
     * 2. If the current tab tab is not currently selected, get the last route
     *    view from the router outlet.
     *
     *   a. If the last route view exists, navigate to that view including any
     *      navigation extras
     *   b. If the last route view doesn't exist, then navigate
     *      to the default tabRootUrl
     */
    select(tabOrEvent) {
        const isTabString = typeof tabOrEvent === 'string';
        const tab = isTabString ? tabOrEvent : tabOrEvent.detail.tab;
        const alreadySelected = this.outlet.getActiveStackId() === tab;
        const tabRootUrl = `${this.outlet.tabsPrefix}/${tab}`;
        /**
         * If this is a nested tab, prevent the event
         * from bubbling otherwise the outer tabs
         * will respond to this event too, causing
         * the app to get directed to the wrong place.
         */
        if (!isTabString) {
            tabOrEvent.stopPropagation();
        }
        if (alreadySelected) {
            const activeStackId = this.outlet.getActiveStackId();
            const activeView = this.outlet.getLastRouteView(activeStackId);
            // If on root tab, do not navigate to root tab again
            if (activeView?.url === tabRootUrl) {
                return;
            }
            const rootView = this.outlet.getRootView(tab);
            const navigationExtras = rootView && tabRootUrl === rootView.url && rootView.savedExtras;
            return this.navCtrl.navigateRoot(tabRootUrl, {
                ...navigationExtras,
                animated: true,
                animationDirection: 'back',
            });
        }
        else {
            const lastRoute = this.outlet.getLastRouteView(tab);
            /**
             * If there is a lastRoute, goto that, otherwise goto the fallback url of the
             * selected tab
             */
            const url = lastRoute?.url || tabRootUrl;
            const navigationExtras = lastRoute?.savedExtras;
            return this.navCtrl.navigateRoot(url, {
                ...navigationExtras,
                animated: true,
                animationDirection: 'back',
            });
        }
    }
    getSelected() {
        return this.outlet.getActiveStackId();
    }
    /**
     * Detects changes to the slot attribute of the tab bar.
     *
     * If the slot attribute has changed, then the tab bar
     * should be relocated to the new slot position.
     */
    detectSlotChanges() {
        this.tabBars.forEach((tabBar) => {
            // el is a protected attribute from the generated component wrapper
            const currentSlot = tabBar.el.getAttribute('slot');
            if (currentSlot !== this.tabBarSlot) {
                this.tabBarSlot = currentSlot;
                this.relocateTabBar();
            }
        });
    }
    /**
     * Relocates the tab bar to the new slot position.
     */
    relocateTabBar() {
        /**
         * `el` is a protected attribute from the generated component wrapper.
         * To avoid having to manually create the wrapper for tab bar, we
         * cast the tab bar to any and access the protected attribute.
         */
        const tabBar = this.tabBar.el;
        if (this.tabBarSlot === 'top') {
            /**
             * A tab bar with a slot of "top" should be inserted
             * at the top of the container.
             */
            this.tabsInner.nativeElement.before(tabBar);
        }
        else {
            /**
             * A tab bar with a slot of "bottom" or without a slot
             * should be inserted at the end of the container.
             */
            this.tabsInner.nativeElement.after(tabBar);
        }
    }
}
/** @nocollapse */ IonTabs.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonTabs, deps: [{ token: i1.NavController }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ IonTabs.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.12", type: IonTabs, selector: "ion-tabs", outputs: { ionTabsWillChange: "ionTabsWillChange", ionTabsDidChange: "ionTabsDidChange" }, host: { listeners: { "ionTabButtonClick": "select($event)" } }, viewQueries: [{ propertyName: "tabsInner", first: true, predicate: ["tabsInner"], descendants: true, read: ElementRef, static: true }], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonTabs, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-tabs',
                }]
        }], ctorParameters: function () { return [{ type: i1.NavController }]; }, propDecorators: { tabsInner: [{
                type: ViewChild,
                args: ['tabsInner', { read: ElementRef, static: true }]
            }], ionTabsWillChange: [{
                type: Output
            }], ionTabsDidChange: [{
                type: Output
            }], select: [{
                type: HostListener,
                args: ['ionTabButtonClick', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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