import { __decorate } from "tslib";
import { ContentChild, Directive, TemplateRef, } from '@angular/core';
import { ProxyCmp, proxyOutputs } from '../utils/proxy';
import * as i0 from "@angular/core";
const MODAL_INPUTS = [
    'animated',
    'keepContentsMounted',
    'backdropBreakpoint',
    'backdropDismiss',
    'breakpoints',
    'canDismiss',
    'cssClass',
    'enterAnimation',
    'event',
    'handle',
    'handleBehavior',
    'initialBreakpoint',
    'isOpen',
    'keyboardClose',
    'leaveAnimation',
    'mode',
    'presentingElement',
    'showBackdrop',
    'translucent',
    'trigger',
];
const MODAL_METHODS = [
    'present',
    'dismiss',
    'onDidDismiss',
    'onWillDismiss',
    'setCurrentBreakpoint',
    'getCurrentBreakpoint',
];
let IonModal = class IonModal {
    constructor(c, r, z) {
        this.z = z;
        this.isCmpOpen = false;
        this.el = r.nativeElement;
        this.el.addEventListener('ionMount', () => {
            this.isCmpOpen = true;
            c.detectChanges();
        });
        this.el.addEventListener('didDismiss', () => {
            this.isCmpOpen = false;
            c.detectChanges();
        });
        proxyOutputs(this, this.el, [
            'ionModalDidPresent',
            'ionModalWillPresent',
            'ionModalWillDismiss',
            'ionModalDidDismiss',
            'ionBreakpointDidChange',
            'didPresent',
            'willPresent',
            'willDismiss',
            'didDismiss',
        ]);
    }
};
/** @nocollapse */ IonModal.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonModal, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ IonModal.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.12", type: IonModal, selector: "ion-modal", inputs: { animated: "animated", keepContentsMounted: "keepContentsMounted", backdropBreakpoint: "backdropBreakpoint", backdropDismiss: "backdropDismiss", breakpoints: "breakpoints", canDismiss: "canDismiss", cssClass: "cssClass", enterAnimation: "enterAnimation", event: "event", handle: "handle", handleBehavior: "handleBehavior", initialBreakpoint: "initialBreakpoint", isOpen: "isOpen", keyboardClose: "keyboardClose", leaveAnimation: "leaveAnimation", mode: "mode", presentingElement: "presentingElement", showBackdrop: "showBackdrop", translucent: "translucent", trigger: "trigger" }, queries: [{ propertyName: "template", first: true, predicate: TemplateRef, descendants: true }], ngImport: i0 });
IonModal = __decorate([
    ProxyCmp({
        inputs: MODAL_INPUTS,
        methods: MODAL_METHODS,
    })
    /**
     * @Component extends from @Directive
     * so by defining the inputs here we
     * do not need to re-define them for the
     * lazy loaded popover.
     */
], IonModal);
export { IonModal };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonModal, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-modal',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: MODAL_INPUTS,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }]; }, propDecorators: { template: [{
                type: ContentChild,
                args: [TemplateRef, { static: false }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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