import { __decorate } from "tslib";
import { ContentChild, Directive, TemplateRef, } from '@angular/core';
import { ProxyCmp, proxyOutputs } from '../utils/proxy';
import * as i0 from "@angular/core";
const POPOVER_INPUTS = [
    'alignment',
    'animated',
    'arrow',
    'keepContentsMounted',
    'backdropDismiss',
    'cssClass',
    'dismissOnSelect',
    'enterAnimation',
    'event',
    'isOpen',
    'keyboardClose',
    'leaveAnimation',
    'mode',
    'showBackdrop',
    'translucent',
    'trigger',
    'triggerAction',
    'reference',
    'size',
    'side',
];
const POPOVER_METHODS = ['present', 'dismiss', 'onDidDismiss', 'onWillDismiss'];
let IonPopover = class IonPopover {
    constructor(c, r, z) {
        this.z = z;
        this.isCmpOpen = false;
        this.el = r.nativeElement;
        this.el.addEventListener('ionMount', () => {
            this.isCmpOpen = true;
            c.detectChanges();
        });
        this.el.addEventListener('didDismiss', () => {
            this.isCmpOpen = false;
            c.detectChanges();
        });
        proxyOutputs(this, this.el, [
            'ionPopoverDidPresent',
            'ionPopoverWillPresent',
            'ionPopoverWillDismiss',
            'ionPopoverDidDismiss',
            'didPresent',
            'willPresent',
            'willDismiss',
            'didDismiss',
        ]);
    }
};
/** @nocollapse */ IonPopover.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonPopover, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ IonPopover.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.12", type: IonPopover, selector: "ion-popover", inputs: { alignment: "alignment", animated: "animated", arrow: "arrow", keepContentsMounted: "keepContentsMounted", backdropDismiss: "backdropDismiss", cssClass: "cssClass", dismissOnSelect: "dismissOnSelect", enterAnimation: "enterAnimation", event: "event", isOpen: "isOpen", keyboardClose: "keyboardClose", leaveAnimation: "leaveAnimation", mode: "mode", showBackdrop: "showBackdrop", translucent: "translucent", trigger: "trigger", triggerAction: "triggerAction", reference: "reference", size: "size", side: "side" }, queries: [{ propertyName: "template", first: true, predicate: TemplateRef, descendants: true }], ngImport: i0 });
IonPopover = __decorate([
    ProxyCmp({
        inputs: POPOVER_INPUTS,
        methods: POPOVER_METHODS,
    })
    /**
     * @Component extends from @Directive
     * so by defining the inputs here we
     * do not need to re-define them for the
     * lazy loaded popover.
     */
], IonPopover);
export { IonPopover };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonPopover, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-popover',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: POPOVER_INPUTS,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }]; }, propDecorators: { template: [{
                type: ContentChild,
                args: [TemplateRef, { static: false }]
            }] } });
//# sourceMappingURL=data:application/json;base64,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