import { ApplicationRef, NgZone, Injectable, Injector, inject, createComponent, InjectionToken, } from '@angular/core';
import { LIFECYCLE_DID_ENTER, LIFECYCLE_DID_LEAVE, LIFECYCLE_WILL_ENTER, LIFECYCLE_WILL_LEAVE, LIFECYCLE_WILL_UNLOAD, } from '@ionic/core/components';
import { NavParams } from '../directives/navigation/nav-params';
import * as i0 from "@angular/core";
// TODO(FW-2827): types
export class AngularDelegate {
    constructor() {
        this.zone = inject(NgZone);
        this.applicationRef = inject(ApplicationRef);
    }
    create(environmentInjector, injector, elementReferenceKey) {
        return new AngularFrameworkDelegate(environmentInjector, injector, this.applicationRef, this.zone, elementReferenceKey);
    }
}
/** @nocollapse */ AngularDelegate.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: AngularDelegate, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ AngularDelegate.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: AngularDelegate });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: AngularDelegate, decorators: [{
            type: Injectable
        }] });
export class AngularFrameworkDelegate {
    constructor(environmentInjector, injector, applicationRef, zone, elementReferenceKey) {
        this.environmentInjector = environmentInjector;
        this.injector = injector;
        this.applicationRef = applicationRef;
        this.zone = zone;
        this.elementReferenceKey = elementReferenceKey;
        this.elRefMap = new WeakMap();
        this.elEventsMap = new WeakMap();
    }
    attachViewToDom(container, component, params, cssClasses) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentProps = {
                    ...params,
                };
                /**
                 * Ionic Angular passes a reference to a modal
                 * or popover that can be accessed using a
                 * variable in the overlay component. If
                 * elementReferenceKey is defined, then we should
                 * pass a reference to the component using
                 * elementReferenceKey as the key.
                 */
                if (this.elementReferenceKey !== undefined) {
                    componentProps[this.elementReferenceKey] = container;
                }
                const el = attachView(this.zone, this.environmentInjector, this.injector, this.applicationRef, this.elRefMap, this.elEventsMap, container, component, componentProps, cssClasses, this.elementReferenceKey);
                resolve(el);
            });
        });
    }
    removeViewFromDom(_container, component) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentRef = this.elRefMap.get(component);
                if (componentRef) {
                    componentRef.destroy();
                    this.elRefMap.delete(component);
                    const unbindEvents = this.elEventsMap.get(component);
                    if (unbindEvents) {
                        unbindEvents();
                        this.elEventsMap.delete(component);
                    }
                }
                resolve();
            });
        });
    }
}
export const attachView = (zone, environmentInjector, injector, applicationRef, elRefMap, elEventsMap, container, component, params, cssClasses, elementReferenceKey) => {
    /**
     * Wraps the injector with a custom injector that
     * provides NavParams to the component.
     *
     * NavParams is a legacy feature from Ionic v3 that allows
     * Angular developers to provide data to a component
     * and access it by providing NavParams as a dependency
     * in the constructor.
     *
     * The modern approach is to access the data directly
     * from the component's class instance.
     */
    const childInjector = Injector.create({
        providers: getProviders(params),
        parent: injector,
    });
    const componentRef = createComponent(component, {
        environmentInjector,
        elementInjector: childInjector,
    });
    const instance = componentRef.instance;
    const hostElement = componentRef.location.nativeElement;
    if (params) {
        /**
         * For modals and popovers, a reference to the component is
         * added to `params` during the call to attachViewToDom. If
         * a reference using this name is already set, this means
         * the app is trying to use the name as a component prop,
         * which will cause collisions.
         */
        if (elementReferenceKey && instance[elementReferenceKey] !== undefined) {
            console.error(`[Ionic Error]: ${elementReferenceKey} is a reserved property when using ${container.tagName.toLowerCase()}. Rename or remove the "${elementReferenceKey}" property from ${component.name}.`);
        }
        Object.assign(instance, params);
    }
    if (cssClasses) {
        for (const cssClass of cssClasses) {
            hostElement.classList.add(cssClass);
        }
    }
    const unbindEvents = bindLifecycleEvents(zone, instance, hostElement);
    container.appendChild(hostElement);
    applicationRef.attachView(componentRef.hostView);
    elRefMap.set(hostElement, componentRef);
    elEventsMap.set(hostElement, unbindEvents);
    return hostElement;
};
const LIFECYCLES = [
    LIFECYCLE_WILL_ENTER,
    LIFECYCLE_DID_ENTER,
    LIFECYCLE_WILL_LEAVE,
    LIFECYCLE_DID_LEAVE,
    LIFECYCLE_WILL_UNLOAD,
];
export const bindLifecycleEvents = (zone, instance, element) => {
    return zone.run(() => {
        const unregisters = LIFECYCLES.filter((eventName) => typeof instance[eventName] === 'function').map((eventName) => {
            const handler = (ev) => instance[eventName](ev.detail);
            element.addEventListener(eventName, handler);
            return () => element.removeEventListener(eventName, handler);
        });
        return () => unregisters.forEach((fn) => fn());
    });
};
const NavParamsToken = new InjectionToken('NavParamsToken');
const getProviders = (params) => {
    return [
        {
            provide: NavParamsToken,
            useValue: params,
        },
        {
            provide: NavParams,
            useFactory: provideNavParamsInjectable,
            deps: [NavParamsToken],
        },
    ];
};
const provideNavParamsInjectable = (params) => {
    return new NavParams(params);
};
//# sourceMappingURL=data:application/json;base64,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