import { CommonModule, DOCUMENT } from '@angular/common';
import { APP_INITIALIZER, NgModule, NgZone } from '@angular/core';
import { ConfigToken, AngularDelegate, provideComponentInputBinding } from '@ionic/angular/common';
import { appInitialize } from './app-initialize';
import { BooleanValueAccessorDirective, NumericValueAccessorDirective, RadioValueAccessorDirective, SelectValueAccessorDirective, TextValueAccessorDirective, } from './directives/control-value-accessors';
import { IonBackButton } from './directives/navigation/ion-back-button';
import { IonNav } from './directives/navigation/ion-nav';
import { IonRouterOutlet } from './directives/navigation/ion-router-outlet';
import { IonTabs } from './directives/navigation/ion-tabs';
import { RouterLinkDelegateDirective, RouterLinkWithHrefDelegateDirective, } from './directives/navigation/router-link-delegate';
import { IonModal } from './directives/overlays/modal';
import { IonPopover } from './directives/overlays/popover';
import { DIRECTIVES } from './directives/proxies-list';
import { IonMaxValidator, IonMinValidator } from './directives/validators';
import { ModalController } from './providers/modal-controller';
import { PopoverController } from './providers/popover-controller';
import * as i0 from "@angular/core";
import * as i1 from "./directives/proxies";
const DECLARATIONS = [
    // generated proxies
    ...DIRECTIVES,
    // manual proxies
    IonModal,
    IonPopover,
    // ngModel accessors
    BooleanValueAccessorDirective,
    NumericValueAccessorDirective,
    RadioValueAccessorDirective,
    SelectValueAccessorDirective,
    TextValueAccessorDirective,
    // navigation
    IonTabs,
    IonRouterOutlet,
    IonBackButton,
    IonNav,
    RouterLinkDelegateDirective,
    RouterLinkWithHrefDelegateDirective,
    // validators
    IonMinValidator,
    IonMaxValidator,
];
export class IonicModule {
    static forRoot(config) {
        return {
            ngModule: IonicModule,
            providers: [
                {
                    provide: ConfigToken,
                    useValue: config,
                },
                {
                    provide: APP_INITIALIZER,
                    useFactory: appInitialize,
                    multi: true,
                    deps: [ConfigToken, DOCUMENT, NgZone],
                },
                provideComponentInputBinding(),
            ],
        };
    }
}
/** @nocollapse */ IonicModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonicModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ IonicModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.12", ngImport: i0, type: IonicModule, declarations: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonActionSheet, i1.IonAlert, i1.IonApp, i1.IonAvatar, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonLoading, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNavLink, i1.IonNote, i1.IonPicker, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSelect, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSpinner, i1.IonSplitPane, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToast, i1.IonToggle, i1.IonToolbar, 
        // manual proxies
        IonModal,
        IonPopover,
        // ngModel accessors
        BooleanValueAccessorDirective,
        NumericValueAccessorDirective,
        RadioValueAccessorDirective,
        SelectValueAccessorDirective,
        TextValueAccessorDirective,
        // navigation
        IonTabs,
        IonRouterOutlet,
        IonBackButton,
        IonNav,
        RouterLinkDelegateDirective,
        RouterLinkWithHrefDelegateDirective,
        // validators
        IonMinValidator,
        IonMaxValidator], imports: [CommonModule], exports: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonActionSheet, i1.IonAlert, i1.IonApp, i1.IonAvatar, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonLoading, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNavLink, i1.IonNote, i1.IonPicker, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSelect, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSpinner, i1.IonSplitPane, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToast, i1.IonToggle, i1.IonToolbar, 
        // manual proxies
        IonModal,
        IonPopover,
        // ngModel accessors
        BooleanValueAccessorDirective,
        NumericValueAccessorDirective,
        RadioValueAccessorDirective,
        SelectValueAccessorDirective,
        TextValueAccessorDirective,
        // navigation
        IonTabs,
        IonRouterOutlet,
        IonBackButton,
        IonNav,
        RouterLinkDelegateDirective,
        RouterLinkWithHrefDelegateDirective,
        // validators
        IonMinValidator,
        IonMaxValidator] });
/** @nocollapse */ IonicModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonicModule, providers: [AngularDelegate, ModalController, PopoverController], imports: [CommonModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonicModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: DECLARATIONS,
                    exports: DECLARATIONS,
                    providers: [AngularDelegate, ModalController, PopoverController],
                    imports: [CommonModule],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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