import { __decorate } from "tslib";
import { ChangeDetectionStrategy, Component, HostListener, forwardRef, } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessor } from '@ionic/angular/common';
import { defineCustomElement } from '@ionic/core/components/ion-select.js';
import { ProxyCmp, proxyOutputs } from './angular-component-lib/utils';
import * as i0 from "@angular/core";
const SELECT_INPUTS = [
    'cancelText',
    'color',
    'compareWith',
    'disabled',
    'expandedIcon',
    'fill',
    'interface',
    'interfaceOptions',
    'justify',
    'label',
    'labelPlacement',
    'legacy',
    'mode',
    'multiple',
    'name',
    'okText',
    'placeholder',
    'selectedText',
    'shape',
    'toggleIcon',
    'value',
];
/**
 * Pulling the provider into an object and using PURE works
 * around an ng-packagr issue that causes
 * components with multiple decorators and
 * a provider to be re-assigned. This re-assignment
 * is not supported by Webpack and causes treeshaking
 * to not work on these kinds of components.
 */
const accessorProvider = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ forwardRef(() => IonSelect),
    multi: true,
};
let IonSelect = class IonSelect extends ValueAccessor {
    constructor(c, r, z, injector) {
        super(injector, r);
        this.z = z;
        c.detach();
        this.el = r.nativeElement;
        proxyOutputs(this, this.el, ['ionChange', 'ionCancel', 'ionDismiss', 'ionFocus', 'ionBlur']);
    }
    handleIonChange(el) {
        this.handleValueChange(el, el.value);
    }
};
/** @nocollapse */ IonSelect.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonSelect, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.Injector }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ IonSelect.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.12", type: IonSelect, isStandalone: true, selector: "ion-select", inputs: { cancelText: "cancelText", color: "color", compareWith: "compareWith", disabled: "disabled", expandedIcon: "expandedIcon", fill: "fill", interface: "interface", interfaceOptions: "interfaceOptions", justify: "justify", label: "label", labelPlacement: "labelPlacement", legacy: "legacy", mode: "mode", multiple: "multiple", name: "name", okText: "okText", placeholder: "placeholder", selectedText: "selectedText", shape: "shape", toggleIcon: "toggleIcon", value: "value" }, host: { listeners: { "ionChange": "handleIonChange($event.target)" } }, providers: [accessorProvider], usesInheritance: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush });
IonSelect = __decorate([
    ProxyCmp({
        defineCustomElementFn: defineCustomElement,
        inputs: SELECT_INPUTS,
        methods: ['open'],
    })
], IonSelect);
export { IonSelect };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonSelect, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-select',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: '<ng-content></ng-content>',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: SELECT_INPUTS,
                    providers: [accessorProvider],
                    standalone: true,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.Injector }]; }, propDecorators: { handleIonChange: [{
                type: HostListener,
                args: ['ionChange', ['$event.target']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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