import { __decorate } from "tslib";
import { ChangeDetectionStrategy, Component, HostListener, forwardRef, } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessor } from '@ionic/angular/common';
import { defineCustomElement } from '@ionic/core/components/ion-textarea.js';
import { ProxyCmp, proxyOutputs } from './angular-component-lib/utils';
import * as i0 from "@angular/core";
const TEXTAREA_INPUTS = [
    'autoGrow',
    'autocapitalize',
    'autofocus',
    'clearOnEdit',
    'color',
    'cols',
    'counter',
    'counterFormatter',
    'debounce',
    'disabled',
    'enterkeyhint',
    'errorText',
    'fill',
    'helperText',
    'inputmode',
    'label',
    'labelPlacement',
    'legacy',
    'maxlength',
    'minlength',
    'mode',
    'name',
    'placeholder',
    'readonly',
    'required',
    'rows',
    'shape',
    'spellcheck',
    'value',
    'wrap',
];
/**
 * Pulling the provider into an object and using PURE works
 * around an ng-packagr issue that causes
 * components with multiple decorators and
 * a provider to be re-assigned. This re-assignment
 * is not supported by Webpack and causes treeshaking
 * to not work on these kinds of components.
 */
const accessorProvider = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ forwardRef(() => IonTextarea),
    multi: true,
};
let IonTextarea = class IonTextarea extends ValueAccessor {
    constructor(c, r, z, injector) {
        super(injector, r);
        this.z = z;
        c.detach();
        this.el = r.nativeElement;
        proxyOutputs(this, this.el, ['ionChange', 'ionInput', 'ionBlur', 'ionFocus']);
    }
    handleIonInput(el) {
        this.handleValueChange(el, el.value);
    }
};
/** @nocollapse */ IonTextarea.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonTextarea, deps: [{ token: i0.ChangeDetectorRef }, { token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.Injector }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ IonTextarea.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.12", type: IonTextarea, isStandalone: true, selector: "ion-textarea", inputs: { autoGrow: "autoGrow", autocapitalize: "autocapitalize", autofocus: "autofocus", clearOnEdit: "clearOnEdit", color: "color", cols: "cols", counter: "counter", counterFormatter: "counterFormatter", debounce: "debounce", disabled: "disabled", enterkeyhint: "enterkeyhint", errorText: "errorText", fill: "fill", helperText: "helperText", inputmode: "inputmode", label: "label", labelPlacement: "labelPlacement", legacy: "legacy", maxlength: "maxlength", minlength: "minlength", mode: "mode", name: "name", placeholder: "placeholder", readonly: "readonly", required: "required", rows: "rows", shape: "shape", spellcheck: "spellcheck", value: "value", wrap: "wrap" }, host: { listeners: { "ionInput": "handleIonInput($event.target)" } }, providers: [accessorProvider], usesInheritance: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush });
IonTextarea = __decorate([
    ProxyCmp({
        defineCustomElementFn: defineCustomElement,
        inputs: TEXTAREA_INPUTS,
        methods: ['setFocus', 'getInputElement'],
    })
], IonTextarea);
export { IonTextarea };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.12", ngImport: i0, type: IonTextarea, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-textarea',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: '<ng-content></ng-content>',
                    // eslint-disable-next-line @angular-eslint/no-inputs-metadata-property
                    inputs: TEXTAREA_INPUTS,
                    providers: [accessorProvider],
                    standalone: true,
                }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.Injector }]; }, propDecorators: { handleIonInput: [{
                type: HostListener,
                args: ['ionInput', ['$event.target']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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