import { DOCUMENT } from '@angular/common';
import { APP_INITIALIZER } from '@angular/core';
import { AngularDelegate, ConfigToken, provideComponentInputBinding } from '@ionic/angular/common';
import { initialize } from '@ionic/core/components';
import { ModalController } from './modal-controller';
import { PopoverController } from './popover-controller';
export const provideIonicAngular = (config) => {
    /**
     * TODO FW-4967
     * Use makeEnvironmentProviders once Angular 14 support is dropped.
     * This prevents provideIonicAngular from being accidentally referenced in an @Component.
     */
    return [
        {
            provide: ConfigToken,
            useValue: config,
        },
        {
            provide: APP_INITIALIZER,
            useFactory: initializeIonicAngular,
            multi: true,
            deps: [ConfigToken, DOCUMENT],
        },
        provideComponentInputBinding(),
        AngularDelegate,
        ModalController,
        PopoverController,
    ];
};
const initializeIonicAngular = (config, doc) => {
    return () => {
        /**
         * By default Ionic Framework hides elements that
         * are not hydrated, but in the CE build there is no
         * hydration.
         * TODO FW-2797: Remove when all integrations have been
         * migrated to CE build.
         */
        doc.documentElement.classList.add('ion-ce');
        initialize(config);
    };
};
//# sourceMappingURL=data:application/json;base64,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