import { Injector, inject, EnvironmentInjector } from '@angular/core';
import { AngularDelegate, OverlayBaseController } from '@ionic/angular/common';
import { popoverController } from '@ionic/core/components';
import { defineCustomElement } from '@ionic/core/components/ion-popover.js';
export class PopoverController extends OverlayBaseController {
    constructor() {
        super(popoverController);
        this.angularDelegate = inject(AngularDelegate);
        this.injector = inject(Injector);
        this.environmentInjector = inject(EnvironmentInjector);
        defineCustomElement();
    }
    create(opts) {
        return super.create({
            ...opts,
            delegate: this.angularDelegate.create(this.environmentInjector, this.injector, 'popover'),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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