/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-a3a64d73.js');
const theme = require('./theme-d1c573d2.js');
const ionicGlobal = require('./ionic-global-ba1bd66f.js');

const textCss = ":host(.ion-color){color:var(--ion-color-base)}";

const Text = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.color = undefined;
    }
    render() {
        const mode = ionicGlobal.getIonMode(this);
        return (index.h(index.Host, { class: theme.createColorClasses(this.color, {
                [mode]: true,
            }) }, index.h("slot", null)));
    }
};
Text.style = textCss;

exports.ion_text = Text;
