/*!
 * (C) Ionic http://ionicframework.com - MIT License
 */
import { r as registerInstance, h, H as Host } from './index-db215ebe.js';
import { c as createColorClasses } from './theme-01f3f29c.js';
import { b as getIonMode } from './ionic-global-fb3f9f73.js';

const textCss = ":host(.ion-color){color:var(--ion-color-base)}";

const Text = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.color = undefined;
    }
    render() {
        const mode = getIonMode(this);
        return (h(Host, { class: createColorClasses(this.color, {
                [mode]: true,
            }) }, h("slot", null)));
    }
};
Text.style = textCss;

export { Text as ion_text };
