"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forEachExecutorOptionsInGraph = exports.forEachExecutorOptions = void 0;
const nx_1 = require("../../nx");
const { getProjects } = (0, nx_1.requireNx)();
/**
 * Calls a function for each different options that an executor is configured with
 */
function forEachExecutorOptions(tree, 
/**
 * Name of the executor to update options for
 */
executorName, 
/**
 * Callback that is called for each options configured for a builder
 */
callback) {
    forEachProjectConfig(getProjects(tree), executorName, callback);
}
exports.forEachExecutorOptions = forEachExecutorOptions;
/**
 * Calls a function for each different options that an executor is configured with via the project graph
 * this is helpful when you need to get the expaned configuration options from the nx.json
 **/
function forEachExecutorOptionsInGraph(graph, executorName, callback) {
    const projects = new Map();
    Object.values(graph.nodes).forEach((p) => projects.set(p.name, p.data));
    forEachProjectConfig(projects, executorName, callback);
}
exports.forEachExecutorOptionsInGraph = forEachExecutorOptionsInGraph;
function forEachProjectConfig(projects, executorName, callback) {
    for (const [projectName, project] of projects) {
        for (const [targetName, target] of Object.entries(project.targets || {})) {
            if (executorName !== target.executor) {
                continue;
            }
            if (target.options) {
                callback(target.options, projectName, targetName);
            }
            if (!target.configurations) {
                continue;
            }
            Object.entries(target.configurations).forEach(([configName, options]) => {
                callback(options, projectName, targetName, configName);
            });
        }
    }
}
// TODO: add a method for updating options
