"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toJS = void 0;
const versions_1 = require("../utils/versions");
const package_json_1 = require("../utils/package-json");
/**
 * Rename and transpile any new typescript files created to javascript files
 */
function toJS(tree) {
    const { JsxEmit, ScriptTarget, transpile } = (0, package_json_1.ensurePackage)('typescript', versions_1.typescriptVersion);
    for (const c of tree.listChanges()) {
        if ((c.path.endsWith('.ts') || c.path.endsWith('tsx')) &&
            c.type === 'CREATE') {
            tree.write(c.path, transpile(c.content.toString('utf-8'), {
                allowJs: true,
                jsx: JsxEmit.Preserve,
                target: ScriptTarget.ESNext,
            }));
            tree.rename(c.path, c.path.replace(/\.tsx?$/, '.js'));
        }
    }
}
exports.toJS = toJS;
