"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTsConfigsToJs = void 0;
const nx_1 = require("../../nx");
const { updateJson } = (0, nx_1.requireNx)();
function updateTsConfigsToJs(tree, options) {
    let updateConfigPath;
    const paths = {
        tsConfig: `${options.projectRoot}/tsconfig.json`,
        tsConfigLib: `${options.projectRoot}/tsconfig.lib.json`,
        tsConfigApp: `${options.projectRoot}/tsconfig.app.json`,
    };
    const getProjectType = (tree) => {
        if (tree.exists(paths.tsConfigApp)) {
            return 'application';
        }
        if (tree.exists(paths.tsConfigLib)) {
            return 'library';
        }
        throw new Error(`project is missing tsconfig.lib.json or tsconfig.app.json`);
    };
    updateJson(tree, paths.tsConfig, (json) => {
        if (json.compilerOptions) {
            json.compilerOptions.allowJs = true;
        }
        else {
            json.compilerOptions = { allowJs: true };
        }
        return json;
    });
    const projectType = getProjectType(tree);
    if (projectType === 'library') {
        updateConfigPath = paths.tsConfigLib;
    }
    if (projectType === 'application') {
        updateConfigPath = paths.tsConfigApp;
    }
    updateJson(tree, updateConfigPath, (json) => {
        json.include = uniq([...json.include, 'src/**/*.js']);
        json.exclude = uniq([
            ...json.exclude,
            'src/**/*.spec.js',
            'src/**/*.test.js',
        ]);
        return json;
    });
}
exports.updateTsConfigsToJs = updateTsConfigsToJs;
const uniq = (value) => [...new Set(value)];
