"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractLayoutDirectory = exports.getWorkspaceLayout = void 0;
const nx_1 = require("../../nx");
const { readNxJson } = (0, nx_1.requireNx)();
/**
 * Returns workspace defaults. It includes defaults folders for apps and libs,
 * and the default scope.
 *
 * Example:
 *
 * ```typescript
 * { appsDir: 'apps', libsDir: 'libs', npmScope: 'myorg' }
 * ```
 * @param tree - file system tree
 */
function getWorkspaceLayout(tree) {
    var _a, _b, _c, _d;
    const nxJson = readNxJson(tree);
    return {
        appsDir: (_b = (_a = nxJson === null || nxJson === void 0 ? void 0 : nxJson.workspaceLayout) === null || _a === void 0 ? void 0 : _a.appsDir) !== null && _b !== void 0 ? _b : inOrderOfPreference(tree, ['apps', 'packages'], '.'),
        libsDir: (_d = (_c = nxJson === null || nxJson === void 0 ? void 0 : nxJson.workspaceLayout) === null || _c === void 0 ? void 0 : _c.libsDir) !== null && _d !== void 0 ? _d : inOrderOfPreference(tree, ['libs', 'packages'], '.'),
        npmScope: nxJson === null || nxJson === void 0 ? void 0 : nxJson.npmScope,
        standaloneAsDefault: true,
    };
}
exports.getWorkspaceLayout = getWorkspaceLayout;
/**
 * Experimental
 */
function extractLayoutDirectory(directory) {
    if (directory) {
        directory = directory.startsWith('/') ? directory.substring(1) : directory;
        for (let dir of ['apps', 'libs', 'packages']) {
            if (directory.startsWith(dir + '/') || directory === dir) {
                return {
                    layoutDirectory: dir,
                    projectDirectory: directory.substring(dir.length + 1),
                };
            }
        }
    }
    return { layoutDirectory: null, projectDirectory: directory };
}
exports.extractLayoutDirectory = extractLayoutDirectory;
function inOrderOfPreference(tree, selectedFolders, defaultChoice) {
    for (let i = 0; i < selectedFolders.length; ++i) {
        if (tree.exists(selectedFolders[i]))
            return selectedFolders[i];
    }
    return defaultChoice;
}
