"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readRootPackageJson = void 0;
const fs_1 = require("fs");
const nx_1 = require("../../../nx");
const { workspaceRoot, readJsonFile, joinPathFragments } = (0, nx_1.requireNx)();
function readRootPackageJson() {
    const pkgJsonPath = joinPathFragments(workspaceRoot, 'package.json');
    if (!(0, fs_1.existsSync)(pkgJsonPath)) {
        throw new Error('NX MF: Could not find root package.json to determine dependency versions.');
    }
    return readJsonFile(pkgJsonPath);
}
exports.readRootPackageJson = readRootPackageJson;
