"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapRemotesForSSR = exports.mapRemotes = void 0;
const path_1 = require("path");
/**
 * Map remote names to a format that can be understood and used by Module
 * Federation.
 *
 * @param remotes - The remotes to map
 * @param remoteEntryExt - The file extension of the remoteEntry file
 * @param determineRemoteUrl - The function used to lookup the URL of the served remote
 */
function mapRemotes(remotes, remoteEntryExt, determineRemoteUrl) {
    const mappedRemotes = {};
    for (const remote of remotes) {
        if (Array.isArray(remote)) {
            const [remoteName, remoteLocation] = remote;
            const remoteLocationExt = (0, path_1.extname)(remoteLocation);
            mappedRemotes[remoteName] = ['.js', '.mjs'].includes(remoteLocationExt)
                ? remoteLocation
                : `${remoteLocation.endsWith('/')
                    ? remoteLocation.slice(0, -1)
                    : remoteLocation}/remoteEntry.${remoteEntryExt}`;
        }
        else if (typeof remote === 'string') {
            mappedRemotes[remote] = determineRemoteUrl(remote);
        }
    }
    return mappedRemotes;
}
exports.mapRemotes = mapRemotes;
/**
 * Map remote names to a format that can be understood and used by Module
 * Federation.
 *
 * @param remotes - The remotes to map
 * @param remoteEntryExt - The file extension of the remoteEntry file
 * @param determineRemoteUrl - The function used to lookup the URL of the served remote
 */
function mapRemotesForSSR(remotes, remoteEntryExt, determineRemoteUrl) {
    const mappedRemotes = {};
    for (const remote of remotes) {
        if (Array.isArray(remote)) {
            const [remoteName, remoteLocation] = remote;
            const remoteLocationExt = (0, path_1.extname)(remoteLocation);
            mappedRemotes[remoteName] = `${remoteName}@${['.js', '.mjs'].includes(remoteLocationExt)
                ? remoteLocation
                : `${remoteLocation.endsWith('/')
                    ? remoteLocation.slice(0, -1)
                    : remoteLocation}/remoteEntry.${remoteEntryExt}`}`;
        }
        else if (typeof remote === 'string') {
            mappedRemotes[remote] = `${remote}@${determineRemoteUrl(remote)}`;
        }
    }
    return mappedRemotes;
}
exports.mapRemotesForSSR = mapRemotesForSSR;
