"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRootTsConfigPath = exports.readTsConfig = exports.readTsPathMappings = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const nx_1 = require("../../../nx");
const { workspaceRoot } = (0, nx_1.requireNx)();
let tsConfig;
let tsPathMappings;
function readTsPathMappings(tsConfigPath) {
    var _a, _b, _c;
    if (tsConfigPath === void 0) { tsConfigPath = (_a = process.env.NX_TSCONFIG_PATH) !== null && _a !== void 0 ? _a : getRootTsConfigPath(); }
    if (tsPathMappings) {
        return tsPathMappings;
    }
    tsConfig !== null && tsConfig !== void 0 ? tsConfig : (tsConfig = readTsConfiguration(tsConfigPath));
    tsPathMappings = {};
    Object.entries((_c = (_b = tsConfig.options) === null || _b === void 0 ? void 0 : _b.paths) !== null && _c !== void 0 ? _c : {}).forEach(([alias, paths]) => {
        tsPathMappings[alias] = paths.map((path) => path.replace(/^\.\//, ''));
    });
    return tsPathMappings;
}
exports.readTsPathMappings = readTsPathMappings;
function readTsConfiguration(tsConfigPath) {
    if (!(0, fs_1.existsSync)(tsConfigPath)) {
        throw new Error(`NX MF: TsConfig Path for workspace libraries does not exist! (${tsConfigPath}).`);
    }
    return readTsConfig(tsConfigPath);
}
let tsModule;
function readTsConfig(tsConfigPath) {
    if (!tsModule) {
        tsModule = require('typescript');
    }
    const readResult = tsModule.readConfigFile(tsConfigPath, tsModule.sys.readFile);
    return tsModule.parseJsonConfigFileContent(readResult.config, tsModule.sys, (0, path_1.dirname)(tsConfigPath));
}
exports.readTsConfig = readTsConfig;
function getRootTsConfigPath() {
    const tsConfigFileName = getRootTsConfigFileName();
    return tsConfigFileName ? (0, path_1.join)(workspaceRoot, tsConfigFileName) : null;
}
exports.getRootTsConfigPath = getRootTsConfigPath;
function getRootTsConfigFileName() {
    for (const tsConfigName of ['tsconfig.base.json', 'tsconfig.json']) {
        const tsConfigPath = (0, path_1.join)(workspaceRoot, tsConfigName);
        if ((0, fs_1.existsSync)(tsConfigPath)) {
            return tsConfigName;
        }
    }
    return null;
}
