"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.moveFilesToNewDirectory = void 0;
const path_1 = require("path");
const visit_not_ignored_files_1 = require("../generators/visit-not-ignored-files");
const nx_1 = require("../../nx");
const { normalizePath } = (0, nx_1.requireNx)();
/**
 * Analogous to cp -r oldDir newDir
 */
function moveFilesToNewDirectory(tree, oldDir, newDir) {
    oldDir = normalizePath(oldDir);
    newDir = normalizePath(newDir);
    (0, visit_not_ignored_files_1.visitNotIgnoredFiles)(tree, oldDir, (file) => {
        try {
            tree.rename(file, `${newDir}/${(0, path_1.relative)(oldDir, file)}`);
        }
        catch (e) {
            if (!tree.exists(oldDir)) {
                console.warn(`Path ${oldDir} does not exist`);
            }
            else if (!tree.exists(newDir)) {
                console.warn(`Path ${newDir} does not exist`);
            }
        }
    });
}
exports.moveFilesToNewDirectory = moveFilesToNewDirectory;
