"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Builders = exports.ProjectType = void 0;
var ProjectType;
(function (ProjectType) {
    ProjectType["Application"] = "application";
    ProjectType["Library"] = "library";
})(ProjectType || (exports.ProjectType = ProjectType = {}));
/**
 * An enum of the official Angular builders.
 * Each enum value provides the fully qualified name of the associated builder.
 * This enum can be used when analyzing the `builder` fields of project configurations from the
 * `angular.json` workspace file.
 */
var Builders;
(function (Builders) {
    Builders["AppShell"] = "@angular-devkit/build-angular:app-shell";
    Builders["Server"] = "@angular-devkit/build-angular:server";
    Builders["Browser"] = "@angular-devkit/build-angular:browser";
    Builders["Karma"] = "@angular-devkit/build-angular:karma";
    Builders["TsLint"] = "@angular-devkit/build-angular:tslint";
    Builders["DeprecatedNgPackagr"] = "@angular-devkit/build-ng-packagr:build";
    Builders["NgPackagr"] = "@angular-devkit/build-angular:ng-packagr";
    Builders["DevServer"] = "@angular-devkit/build-angular:dev-server";
    Builders["ExtractI18n"] = "@angular-devkit/build-angular:extract-i18n";
    Builders["Protractor"] = "@angular-devkit/build-angular:protractor";
})(Builders || (exports.Builders = Builders = {}));
//# sourceMappingURL=data:application/json;base64,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