"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileProject = void 0;
const utils_fs_1 = require("@ionic/utils-fs");
const path_1 = require("path");
const project_1 = require("./android/project");
const capacitor_1 = require("./frameworks/capacitor");
const cordova_1 = require("./frameworks/cordova");
const flutter_1 = require("./frameworks/flutter");
const dotnet_maui_1 = require("./frameworks/dotnet-maui");
const react_native_1 = require("./frameworks/react-native");
const project_2 = require("./ios/project");
const vfs_1 = require("./vfs");
const native_ios_1 = require("./frameworks/native-ios");
const native_android_1 = require("./frameworks/native-android");
const nativescript_1 = require("./frameworks/nativescript");
class MobileProject {
    constructor(projectRoot, config = {}) {
        var _a, _b;
        this.projectRoot = projectRoot;
        this.config = config;
        this.framework = null;
        this.ios = null;
        this.android = null;
        this.vfs = new vfs_1.VFS();
        this.config.projectRoot = projectRoot;
        if (this.config.ios) {
            this.config.ios.path = (0, path_1.join)(this.projectRoot, (_a = this.config.ios.path) !== null && _a !== void 0 ? _a : '');
        }
        if (this.config.android) {
            this.config.android.path = (0, path_1.join)(this.projectRoot, (_b = this.config.android.path) !== null && _b !== void 0 ? _b : '');
        }
    }
    async detectFramework() {
        var _a;
        const frameworks = [
            flutter_1.FlutterFramework,
            react_native_1.ReactNativeFramework,
            capacitor_1.CapacitorFramework,
            cordova_1.CordovaFramework,
            dotnet_maui_1.DotNetMauiFramework,
            nativescript_1.NativeScriptFramework,
            native_ios_1.NativeIosFramework,
            native_android_1.NativeAndroidFramework,
        ];
        const results = await Promise.all(frameworks.map(f => f.getFramework(this)));
        return (_a = results.filter(f => f).find(f => !!f)) !== null && _a !== void 0 ? _a : null;
    }
    async load() {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        if (((_b = (_a = this.config) === null || _a === void 0 ? void 0 : _a.android) === null || _b === void 0 ? void 0 : _b.path) &&
            (await (0, utils_fs_1.pathExists)((_c = this.config.android) === null || _c === void 0 ? void 0 : _c.path))) {
            this.android = new project_1.AndroidProject(this);
        }
        if (((_e = (_d = this.config) === null || _d === void 0 ? void 0 : _d.ios) === null || _e === void 0 ? void 0 : _e.path) && (await (0, utils_fs_1.pathExists)((_f = this.config.ios) === null || _f === void 0 ? void 0 : _f.path))) {
            this.ios = new project_2.IosProject(this);
        }
        this.framework = await this.detectFramework();
        await ((_g = this.ios) === null || _g === void 0 ? void 0 : _g.load());
        await ((_h = this.android) === null || _h === void 0 ? void 0 : _h.load());
    }
    commit() {
        return this.vfs.commitAll();
    }
}
exports.MobileProject = MobileProject;
//# sourceMappingURL=project.js.map