"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsHistogram = exports.WasmHistogram = exports.Recorder = exports.HistogramLogWriter = exports.encodeIntoCompressedBase64 = exports.decodeFromCompressedBase64 = exports.ByteBuffer = exports.build = exports.listTags = exports.HistogramLogReader = exports.PackedHistogram = exports.Float64Histogram = exports.Int32Histogram = exports.Int16Histogram = exports.Int8Histogram = exports.initWebAssemblySync = exports.initWebAssembly = void 0;
/*
 * This is a TypeScript port of the original Java version, which was written by
 * Gil Tene as described in
 * https://github.com/HdrHistogram/HdrHistogram
 * and released to the public domain, as explained at
 * http://creativecommons.org/publicdomain/zero/1.0/
 */
const ByteBuffer_1 = require("./ByteBuffer");
exports.ByteBuffer = ByteBuffer_1.default;
const encoding_1 = require("./encoding");
Object.defineProperty(exports, "decodeFromCompressedBase64", { enumerable: true, get: function () { return encoding_1.decodeFromCompressedBase64; } });
Object.defineProperty(exports, "encodeIntoCompressedBase64", { enumerable: true, get: function () { return encoding_1.encodeIntoCompressedBase64; } });
const Float64Histogram_1 = require("./Float64Histogram");
exports.Float64Histogram = Float64Histogram_1.default;
const HistogramLogReader_1 = require("./HistogramLogReader");
exports.HistogramLogReader = HistogramLogReader_1.default;
Object.defineProperty(exports, "listTags", { enumerable: true, get: function () { return HistogramLogReader_1.listTags; } });
const HistogramLogWriter_1 = require("./HistogramLogWriter");
exports.HistogramLogWriter = HistogramLogWriter_1.default;
const Int16Histogram_1 = require("./Int16Histogram");
exports.Int16Histogram = Int16Histogram_1.default;
const Int32Histogram_1 = require("./Int32Histogram");
exports.Int32Histogram = Int32Histogram_1.default;
const Int8Histogram_1 = require("./Int8Histogram");
exports.Int8Histogram = Int8Histogram_1.default;
const JsHistogram_1 = require("./JsHistogram");
exports.JsHistogram = JsHistogram_1.default;
const PackedHistogram_1 = require("./PackedHistogram");
exports.PackedHistogram = PackedHistogram_1.default;
const Recorder_1 = require("./Recorder");
exports.Recorder = Recorder_1.default;
const wasm_1 = require("./wasm");
Object.defineProperty(exports, "initWebAssembly", { enumerable: true, get: function () { return wasm_1.initWebAssembly; } });
Object.defineProperty(exports, "initWebAssemblySync", { enumerable: true, get: function () { return wasm_1.initWebAssemblySync; } });
Object.defineProperty(exports, "WasmHistogram", { enumerable: true, get: function () { return wasm_1.WasmHistogram; } });
const HistogramBuilder_1 = require("./HistogramBuilder");
Object.defineProperty(exports, "build", { enumerable: true, get: function () { return HistogramBuilder_1.build; } });
//# sourceMappingURL=index.js.map