"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const project_graph_1 = require("../project-graph/project-graph");
const configuration_1 = require("../config/configuration");
const angular_json_1 = require("./angular-json");
/* eslint-disable */
const Module = require('module');
const originalRequire = Module.prototype.require;
let patched = false;
const allowedProjectExtensions = [
    'tags',
    'implicitDependencies',
    'configFilePath',
    '$schema',
    'generators',
    'namedInputs',
    'name',
    'files',
];
const allowedWorkspaceExtensions = [
    'implicitDependencies',
    'affected',
    'npmScope',
    'tasksRunnerOptions',
    'workspaceLayout',
    'plugins',
    'targetDefaults',
    'files',
    'generators',
    'namedInputs',
];
if (!patched) {
    Module.prototype.require = function () {
        const result = originalRequire.apply(this, arguments);
        if (arguments[0].startsWith('@angular-devkit/core')) {
            const ngCoreWorkspace = originalRequire.apply(this, [
                `@angular-devkit/core/src/workspace/core`,
            ]);
            mockReadWorkspace(ngCoreWorkspace);
            const readJsonUtils = originalRequire.apply(this, [
                `@angular-devkit/core/src/workspace/json/reader`,
            ]);
            mockReadJsonWorkspace(readJsonUtils);
        }
        return result;
    };
    try {
        require('@angular-devkit/build-angular/src/utils/version').Version.assertCompatibleAngularVersion =
            () => { };
    }
    catch (e) { }
    try {
        require('@angular-devkit/build-angular/src/utils/version').assertCompatibleAngularVersion =
            () => { };
    }
    catch (e) { }
    patched = true;
}
function mockReadWorkspace(ngCoreWorkspace) {
    mockMember(ngCoreWorkspace, 'readWorkspace', (originalReadWorkspace) => (path, ...rest) => {
        path = 'angular.json';
        return originalReadWorkspace.apply(this, [path, ...rest]);
    });
}
/**
 * Patch readJsonWorkspace to handle workspaces without a central workspace file.
 * NOTE: We hide warnings that would be logged during this process.
 */
function mockReadJsonWorkspace(readJsonUtils) {
    mockMember(readJsonUtils, 'readJsonWorkspace', (originalReadJsonWorkspace) => (path, host, options) => tslib_1.__awaiter(this, void 0, void 0, function* () {
        const modifiedOptions = Object.assign(Object.assign({}, options), { allowedProjectExtensions,
            allowedWorkspaceExtensions });
        try {
            // Attempt angular CLI default behaviour
            return yield originalReadJsonWorkspace(path, host, modifiedOptions);
        }
        catch (_a) {
            // This failed. Its most likely due to a lack of a workspace definition file,
            // or other things that are different between NgCLI and Nx config files.
            const projectGraph = yield (0, project_graph_1.createProjectGraphAsync)();
            const nxJson = (0, configuration_1.readNxJson)();
            // Construct old workspace.json format from project graph
            const w = Object.assign(Object.assign({}, nxJson), (0, project_graph_1.readProjectsConfigurationFromProjectGraph)(projectGraph));
            // Read our v1 workspace schema
            const workspaceConfiguration = (0, angular_json_1.toOldFormat)(w);
            // readJsonWorkspace actually has AST parsing + more, so we
            // still need to call it rather than just return our file
            return originalReadJsonWorkspace.apply(this, [
                'angular.json',
                {
                    // second arg is a host, only method used is readFile
                    readFile: () => JSON.stringify(workspaceConfiguration),
                },
                modifiedOptions,
            ]);
        }
    }));
}
function mockMember(obj, method, factory) {
    obj[method] = factory(obj[method]);
}
