"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.yargsPrintAffectedCommand = exports.printAffectedDeprecationMessage = exports.yargsAffectedGraphCommand = exports.affectedGraphDeprecationMessage = exports.yargsAffectedE2ECommand = exports.yargsAffectedLintCommand = exports.yargsAffectedBuildCommand = exports.yargsAffectedTestCommand = exports.yargsAffectedCommand = void 0;
const tslib_1 = require("tslib");
const documentation_1 = require("../yargs-utils/documentation");
const shared_options_1 = require("../yargs-utils/shared-options");
exports.yargsAffectedCommand = {
    command: 'affected',
    describe: 'Run target for affected projects',
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withRunOptions)((0, shared_options_1.withOutputStyleOption)((0, shared_options_1.withTargetAndConfigurationOption)(yargs))))
        .option('all', {
        type: 'boolean',
        deprecated: 'Use `nx run-many` instead',
    })
        .middleware((args) => {
        if (args.all !== undefined) {
            throw new Error("The '--all' option has been removed for `nx affected`. Use 'nx run-many' instead.");
        }
    }), 'affected'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () { return (yield Promise.resolve().then(() => require('./affected'))).affected('affected', (0, shared_options_1.withOverrides)(args)); }),
};
exports.yargsAffectedTestCommand = {
    command: 'affected:test',
    describe: false,
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withRunOptions)((0, shared_options_1.withOutputStyleOption)((0, shared_options_1.withConfiguration)(yargs)))), 'affected'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return (yield Promise.resolve().then(() => require('./affected'))).affected('affected', Object.assign(Object.assign({}, (0, shared_options_1.withOverrides)(args)), { target: 'test' }));
    }),
};
exports.yargsAffectedBuildCommand = {
    command: 'affected:build',
    describe: false,
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withRunOptions)((0, shared_options_1.withOutputStyleOption)((0, shared_options_1.withConfiguration)(yargs)))), 'affected'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return (yield Promise.resolve().then(() => require('./affected'))).affected('affected', Object.assign(Object.assign({}, (0, shared_options_1.withOverrides)(args)), { target: 'build' }));
    }),
};
exports.yargsAffectedLintCommand = {
    command: 'affected:lint',
    describe: false,
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withRunOptions)((0, shared_options_1.withOutputStyleOption)((0, shared_options_1.withConfiguration)(yargs)))), 'affected'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return (yield Promise.resolve().then(() => require('./affected'))).affected('affected', Object.assign(Object.assign({}, (0, shared_options_1.withOverrides)(args)), { target: 'lint' }));
    }),
};
exports.yargsAffectedE2ECommand = {
    command: 'affected:e2e',
    describe: false,
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withRunOptions)((0, shared_options_1.withOutputStyleOption)((0, shared_options_1.withConfiguration)(yargs)))), 'affected'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return (yield Promise.resolve().then(() => require('./affected'))).affected('affected', Object.assign(Object.assign({}, (0, shared_options_1.withOverrides)(args)), { target: 'e2e' }));
    }),
};
exports.affectedGraphDeprecationMessage = 'Use `nx graph --affected`, or `nx affected --graph` instead depending on which best suits your use case. The `affected:graph` command will be removed in Nx 18.';
/**
 * @deprecated 'Use `nx graph --affected`, or` nx affected --graph` instead depending on which best suits your use case. The `affected:graph` command will be removed in Nx 18.'
 */
exports.yargsAffectedGraphCommand = {
    command: 'affected:graph',
    describe: 'Graph dependencies affected by changes',
    aliases: ['affected:dep-graph'],
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withDepGraphOptions)(yargs)), 'affected:graph'),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        return yield (yield Promise.resolve().then(() => require('./affected'))).affected('graph', Object.assign({}, args));
    }),
    deprecated: exports.affectedGraphDeprecationMessage,
};
exports.printAffectedDeprecationMessage = 'Use `nx show projects --affected`, `nx affected --graph -t build` or `nx graph --affected` depending on which best suits your use case. The `print-affected` command will be removed in Nx 18.';
/**
 * @deprecated 'Use `nx show --affected`, `nx affected --graph` or `nx graph --affected` depending on which best suits your use case. The `print-affected` command will be removed in Nx 18.'
 */
exports.yargsPrintAffectedCommand = {
    command: 'print-affected',
    describe: 'Prints information about the projects and targets affected by changes',
    builder: (yargs) => (0, documentation_1.linkToNxDevAndExamples)((0, shared_options_1.withAffectedOptions)((0, shared_options_1.withTargetAndConfigurationOption)(yargs, false)), 'print-affected')
        .option('select', {
        type: 'string',
        describe: 'Select the subset of the returned json document (e.g., --select=projects)',
    })
        .option('type', {
        type: 'string',
        choices: ['app', 'lib'],
        describe: 'Select the type of projects to be returned (e.g., --type=app)',
    }),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        yield (yield Promise.resolve().then(() => require('./affected'))).affected('print-affected', (0, shared_options_1.withOverrides)(args));
        process.exit(0);
    }),
    deprecated: exports.printAffectedDeprecationMessage,
};
