"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectPrintAffected = exports.printAffected = void 0;
const tslib_1 = require("tslib");
const utils_1 = require("../../tasks-runner/utils");
const create_task_graph_1 = require("../../tasks-runner/create-task-graph");
const workspaces_1 = require("../../config/workspaces");
const task_hasher_1 = require("../../hasher/task-hasher");
const hash_task_1 = require("../../hasher/hash-task");
const workspace_root_1 = require("../../utils/workspace-root");
const package_manager_1 = require("../../utils/package-manager");
const file_hasher_1 = require("../../hasher/file-hasher");
const command_object_1 = require("./command-object");
const logger_1 = require("../../utils/logger");
/**
 * @deprecated Use showProjectsHandler, generateGraph, or affected (without the print-affected mode) instead.
 */
function printAffected(affectedProjects, projectGraph, { nxJson }, nxArgs, overrides) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        logger_1.logger.warn([logger_1.NX_PREFIX, command_object_1.printAffectedDeprecationMessage].join(' '));
        const projectsForType = affectedProjects.filter((p) => nxArgs.type ? p.type === nxArgs.type : true);
        const projectNames = projectsForType.map((p) => p.name);
        const tasksJson = nxArgs.targets && nxArgs.targets.length > 0
            ? yield createTasks(projectsForType, projectGraph, nxArgs, nxJson, overrides)
            : [];
        const result = {
            tasks: tasksJson,
            projects: projectNames,
            projectGraph: serializeProjectGraph(projectGraph),
        };
        if (nxArgs.select) {
            console.log(selectPrintAffected(result, nxArgs.select));
        }
        else {
            console.log(JSON.stringify(selectPrintAffected(result, null), null, 2));
        }
    });
}
exports.printAffected = printAffected;
function createTasks(affectedProjectsWithTargetAndConfig, projectGraph, nxArgs, nxJson, overrides) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const workspaces = new workspaces_1.Workspaces(workspace_root_1.workspaceRoot);
        const defaultDependencyConfigs = (0, create_task_graph_1.mapTargetDefaultsToDependencies)(nxJson.targetDefaults);
        const taskGraph = (0, create_task_graph_1.createTaskGraph)(projectGraph, defaultDependencyConfigs, affectedProjectsWithTargetAndConfig.map((p) => p.name), nxArgs.targets, nxArgs.configuration, overrides);
        const hasher = new task_hasher_1.InProcessTaskHasher({}, [], projectGraph, taskGraph, nxJson, {}, file_hasher_1.fileHasher);
        const execCommand = (0, package_manager_1.getPackageManagerCommand)().exec;
        const tasks = Object.values(taskGraph.tasks);
        yield Promise.all(tasks.map((t) => (0, hash_task_1.hashTask)(workspaces, hasher, projectGraph, {}, t)));
        return tasks.map((task) => ({
            id: task.id,
            overrides,
            target: task.target,
            hash: task.hash,
            command: (0, utils_1.getCommandAsString)(execCommand, task),
            outputs: (0, utils_1.getOutputs)(projectGraph.nodes, task),
        }));
    });
}
function serializeProjectGraph(projectGraph) {
    const nodes = Object.values(projectGraph.nodes).map((n) => n.name);
    const dependencies = {};
    // we don't need external dependencies' dependencies for print-affected
    // having them included makes the output unreadable
    Object.keys(projectGraph.dependencies).forEach((key) => {
        if (!key.startsWith('npm:')) {
            dependencies[key] = projectGraph.dependencies[key];
        }
    });
    return { nodes, dependencies };
}
function selectPrintAffected(wholeJson, wholeSelect) {
    if (!wholeSelect)
        return wholeJson;
    return _select(wholeJson, wholeSelect);
    function _select(json, select) {
        if (select.indexOf('.') > -1) {
            const [firstKey, ...restKeys] = select.split('.');
            const first = json[firstKey];
            throwIfEmpty(wholeSelect, first);
            const rest = restKeys.join('.');
            if (Array.isArray(first)) {
                return first.map((q) => _select(q, rest)).join(', ');
            }
            else {
                return _select(first, rest);
            }
        }
        else {
            const res = json[select];
            throwIfEmpty(wholeSelect, res);
            if (Array.isArray(res)) {
                return res.join(', ');
            }
            else {
                return res;
            }
        }
    }
}
exports.selectPrintAffected = selectPrintAffected;
function throwIfEmpty(select, value) {
    if (value === undefined) {
        throw new Error(`Cannot select '${select}' in the results of print-affected.`);
    }
}
