"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.yargsExecCommand = void 0;
const tslib_1 = require("tslib");
const shared_options_1 = require("../yargs-utils/shared-options");
exports.yargsExecCommand = {
    command: 'exec',
    describe: 'Executes any command as if it was a target on the project',
    builder: (yargs) => (0, shared_options_1.withRunOneOptions)(yargs),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        try {
            yield (yield Promise.resolve().then(() => require('./exec'))).nxExecCommand((0, shared_options_1.withOverrides)(args));
            process.exit(0);
        }
        catch (e) {
            process.exit(1);
        }
    }),
};
