"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupStandaloneWorkspace = void 0;
const tslib_1 = require("tslib");
const fs_1 = require("fs");
const path_1 = require("path");
const angular_json_1 = require("../../../../adapter/angular-json");
const fileutils_1 = require("../../../../utils/fileutils");
const path_2 = require("../../../../utils/path");
const utils_1 = require("../utils");
function setupStandaloneWorkspace(repoRoot, cacheableOperations, workspaceTargets) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const angularJsonPath = (0, path_1.join)(repoRoot, 'angular.json');
        const angularJson = (0, fileutils_1.readJsonFile)(angularJsonPath);
        const workspaceCapabilities = getWorkspaceCapabilities(angularJson.projects);
        createNxJson(repoRoot, angularJson, cacheableOperations, workspaceCapabilities, workspaceTargets);
        (0, utils_1.addVsCodeRecommendedExtensions)(repoRoot, [
            'nrwl.angular-console',
            'angular.ng-template',
            workspaceCapabilities.eslintProjectConfigFile
                ? 'dbaeumer.vscode-eslint'
                : undefined,
        ].filter(Boolean));
        replaceNgWithNxInPackageJsonScripts(repoRoot);
        // convert workspace config format to standalone project configs
        // update its targets outputs and delete angular.json
        const projects = (0, angular_json_1.toNewFormat)(angularJson).projects;
        for (const [projectName, project] of Object.entries(projects !== null && projects !== void 0 ? projects : {})) {
            updateProjectOutputs(repoRoot, project);
            (0, fileutils_1.writeJsonFile)((0, path_1.join)(project.root, 'project.json'), Object.assign(Object.assign({ $schema: (0, path_2.normalizePath)((0, path_1.relative)((0, path_1.join)(repoRoot, project.root), (0, path_1.join)(repoRoot, 'node_modules/nx/schemas/project-schema.json'))), name: projectName }, project), { root: undefined }));
        }
        (0, fs_1.unlinkSync)(angularJsonPath);
    });
}
exports.setupStandaloneWorkspace = setupStandaloneWorkspace;
function createNxJson(repoRoot, angularJson, cacheableOperations, { eslintProjectConfigFile, test, karmaProjectConfigFile, }, workspaceTargets) {
    (0, utils_1.createNxJsonFile)(repoRoot, [], cacheableOperations, {});
    const nxJson = (0, fileutils_1.readJsonFile)((0, path_1.join)(repoRoot, 'nx.json'));
    nxJson.namedInputs = {
        sharedGlobals: [],
        default: ['{projectRoot}/**/*', 'sharedGlobals'],
        production: [
            'default',
            ...(test
                ? [
                    '!{projectRoot}/tsconfig.spec.json',
                    '!{projectRoot}/**/*.spec.[jt]s',
                    karmaProjectConfigFile ? '!{projectRoot}/karma.conf.js' : undefined,
                ].filter(Boolean)
                : []),
            eslintProjectConfigFile ? '!{projectRoot}/.eslintrc.json' : undefined,
        ].filter(Boolean),
    };
    nxJson.targetDefaults = {};
    if (workspaceTargets.includes('build')) {
        nxJson.targetDefaults.build = {
            dependsOn: ['^build'],
            inputs: ['production', '^production'],
        };
    }
    if (workspaceTargets.includes('server')) {
        nxJson.targetDefaults.server = { inputs: ['production', '^production'] };
    }
    if (workspaceTargets.includes('test')) {
        const inputs = ['default', '^production'];
        if ((0, fileutils_1.fileExists)((0, path_1.join)(repoRoot, 'karma.conf.js'))) {
            inputs.push('{workspaceRoot}/karma.conf.js');
        }
        nxJson.targetDefaults.test = { inputs };
    }
    if (workspaceTargets.includes('lint')) {
        const inputs = ['default'];
        if ((0, fileutils_1.fileExists)((0, path_1.join)(repoRoot, '.eslintrc.json'))) {
            inputs.push('{workspaceRoot}/.eslintrc.json');
        }
        nxJson.targetDefaults.lint = { inputs };
    }
    if (workspaceTargets.includes('e2e')) {
        nxJson.targetDefaults.e2e = { inputs: ['default', '^production'] };
    }
    // Angular 14 workspaces support defaultProject, keep it until we drop support
    nxJson.defaultProject = angularJson.defaultProject;
    (0, fileutils_1.writeJsonFile)((0, path_1.join)(repoRoot, 'nx.json'), nxJson);
}
function updateProjectOutputs(repoRoot, project) {
    var _a;
    Object.values((_a = project.targets) !== null && _a !== void 0 ? _a : {}).forEach((target) => {
        if ([
            '@angular-devkit/build-angular:browser',
            '@angular-builders/custom-webpack:browser',
            'ngx-build-plus:browser',
            '@angular-devkit/build-angular:server',
            '@angular-builders/custom-webpack:server',
            'ngx-build-plus:server',
        ].includes(target.executor)) {
            target.outputs = ['{options.outputPath}'];
        }
        else if (target.executor === '@angular-eslint/builder:lint') {
            target.outputs = ['{options.outputFile}'];
        }
        else if (target.executor === '@angular-devkit/build-angular:ng-packagr') {
            try {
                const ngPackageJsonPath = (0, path_1.join)(repoRoot, target.options.project);
                const ngPackageJson = (0, fileutils_1.readJsonFile)(ngPackageJsonPath);
                const outputPath = (0, path_1.relative)(repoRoot, (0, path_1.resolve)((0, path_1.dirname)(ngPackageJsonPath), ngPackageJson.dest));
                target.outputs = [`{workspaceRoot}/${(0, path_2.normalizePath)(outputPath)}`];
            }
            catch (_a) { }
        }
    });
}
function getWorkspaceCapabilities(projects) {
    const capabilities = {
        eslintProjectConfigFile: false,
        test: false,
        karmaProjectConfigFile: false,
    };
    for (const project of Object.values(projects !== null && projects !== void 0 ? projects : {})) {
        if (!capabilities.eslintProjectConfigFile &&
            projectHasEslintConfig(project)) {
            capabilities.eslintProjectConfigFile = true;
        }
        if (!capabilities.test && projectUsesKarmaBuilder(project)) {
            capabilities.test = true;
        }
        if (!capabilities.karmaProjectConfigFile &&
            projectHasKarmaConfig(project)) {
            capabilities.karmaProjectConfigFile = true;
        }
        if (capabilities.eslintProjectConfigFile &&
            capabilities.test &&
            capabilities.karmaProjectConfigFile) {
            return capabilities;
        }
    }
    return capabilities;
}
function projectUsesKarmaBuilder(project) {
    var _a;
    return Object.values((_a = project.architect) !== null && _a !== void 0 ? _a : {}).some((target) => target.builder === '@angular-devkit/build-angular:karma');
}
function projectHasKarmaConfig(project) {
    return (0, fileutils_1.fileExists)((0, path_1.join)(project.root, 'karma.conf.js'));
}
function projectHasEslintConfig(project) {
    return (0, fileutils_1.fileExists)((0, path_1.join)(project.root, '.eslintrc.json'));
}
function replaceNgWithNxInPackageJsonScripts(repoRoot) {
    var _a;
    const packageJsonPath = (0, path_1.join)(repoRoot, 'package.json');
    const packageJson = (0, fileutils_1.readJsonFile)(packageJsonPath);
    (_a = packageJson.scripts) !== null && _a !== void 0 ? _a : (packageJson.scripts = {});
    Object.keys(packageJson.scripts).forEach((script) => {
        packageJson.scripts[script] = packageJson.scripts[script]
            .replace(/^nx$/, 'nx')
            .replace(/^ng /, 'nx ')
            .replace(/ ng /g, ' nx ');
    });
    (0, fileutils_1.writeJsonFile)(packageJsonPath, packageJson);
}
