"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupE2eProject = void 0;
const fs_1 = require("fs");
const fileutils_1 = require("../../../../utils/fileutils");
function setupE2eProject(appName) {
    const json = (0, fileutils_1.readJsonFile)(`apps/${appName}-e2e/project.json`);
    json.targets.e2e = {
        executor: 'nx:run-commands',
        options: {
            commands: [`nx e2e-serve ${appName}-e2e`, `nx e2e-run ${appName}-e2e`],
        },
    };
    json.targets['e2e-run'] = {
        executor: '@nx/cypress:cypress',
        options: {
            cypressConfig: `apps/${appName}-e2e/cypress.json`,
            tsConfig: `apps/${appName}-e2e/tsconfig.e2e.json`,
            baseUrl: 'http://localhost:3000',
        },
    };
    json.targets['e2e-serve'] = {
        executor: 'nx:run-commands',
        options: {
            commands: [`nx serve ${appName}`],
            readyWhen: 'can now view',
        },
    };
    (0, fileutils_1.writeJsonFile)(`apps/${appName}-e2e/project.json`, json);
    if ((0, fileutils_1.fileExists)(`apps/${appName}-e2e/src/integration/app.spec.ts`)) {
        const integrationE2eTest = `
      describe('${appName}', () => {
        beforeEach(() => cy.visit('/'));
        it('should contain a body', () => {
          cy.get('body').should('exist');
        });
      });`;
        (0, fs_1.writeFileSync)(`apps/${appName}-e2e/src/integration/app.spec.ts`, integrationE2eTest);
    }
}
exports.setupE2eProject = setupE2eProject;
