"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.yargsRunCommand = void 0;
const tslib_1 = require("tslib");
const shared_options_1 = require("../yargs-utils/shared-options");
exports.yargsRunCommand = {
    command: 'run [project][:target][:configuration] [_..]',
    describe: `Run a target for a project
    (e.g., nx run myapp:serve:production).

    You can also use the infix notation to run a target:
    (e.g., nx serve myapp --configuration=production)

    You can skip the use of Nx cache by using the --skip-nx-cache option.`,
    builder: (yargs) => (0, shared_options_1.withRunOneOptions)(yargs),
    handler: (args) => tslib_1.__awaiter(void 0, void 0, void 0, function* () { return (yield Promise.resolve().then(() => require('./run-one'))).runOne(process.cwd(), (0, shared_options_1.withOverrides)(args)); }),
};
