"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizePackageJson = exports.getHoistedPackageVersion = void 0;
const fs_1 = require("fs");
const workspace_root_1 = require("../../../../utils/workspace-root");
/**
 * Get version of hoisted package if available
 */
function getHoistedPackageVersion(packageName) {
    var _a;
    const fullPath = `${workspace_root_1.workspaceRoot}/node_modules/${packageName}/package.json`;
    if ((0, fs_1.existsSync)(fullPath)) {
        const content = (0, fs_1.readFileSync)(fullPath, 'utf-8');
        return (_a = JSON.parse(content)) === null || _a === void 0 ? void 0 : _a.version;
    }
    return;
}
exports.getHoistedPackageVersion = getHoistedPackageVersion;
/**
 * Strip off non-pruning related fields from package.json
 */
function normalizePackageJson(packageJson) {
    const { name, version, license, dependencies, devDependencies, peerDependencies, peerDependenciesMeta, optionalDependencies, } = packageJson;
    return {
        name,
        version,
        license,
        dependencies,
        devDependencies,
        peerDependencies,
        peerDependenciesMeta,
        optionalDependencies,
    };
}
exports.normalizePackageJson = normalizePackageJson;
