"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildExplicitTypeScriptDependencies = void 0;
const typescript_import_locator_1 = require("./typescript-import-locator");
const target_project_locator_1 = require("./target-project-locator");
function buildExplicitTypeScriptDependencies(graph, filesToProcess) {
    function isRoot(projectName) {
        var _a, _b;
        return ((_b = (_a = graph.nodes[projectName]) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.root) === '.';
    }
    const importLocator = new typescript_import_locator_1.TypeScriptImportLocator();
    const targetProjectLocator = new target_project_locator_1.TargetProjectLocator(graph.nodes, graph.externalNodes);
    const res = [];
    Object.keys(filesToProcess).forEach((source) => {
        Object.values(filesToProcess[source]).forEach((f) => {
            importLocator.fromFile(f.file, (importExpr, filePath, type) => {
                const target = targetProjectLocator.findProjectWithImport(importExpr, f.file);
                let targetProjectName;
                if (target) {
                    if (!isRoot(source) && isRoot(target)) {
                        // TODO: These edges technically should be allowed but we need to figure out how to separate config files out from root
                        return;
                    }
                    targetProjectName = target;
                }
                else {
                    // treat all unknowns as npm packages, they can be eiher
                    // - mistyped local import, which has to be fixed manually
                    // - node internals, which should still be tracked as a dependency
                    // - npm packages, which are not yet installed but should be tracked
                    targetProjectName = `npm:${importExpr}`;
                }
                res.push({
                    sourceProjectName: source,
                    targetProjectName,
                    sourceProjectFile: f.file,
                    type,
                });
            });
        });
    });
    return res;
}
exports.buildExplicitTypeScriptDependencies = buildExplicitTypeScriptDependencies;
