import { NxJsonConfiguration } from '../config/nx-json';
import { FileData, ProjectFileMap, ProjectGraph } from '../config/project-graph';
import { ProjectsConfigurations } from '../config/workspace-json-project-json';
export interface ProjectFileMapCache {
    version: string;
    nxVersion: string;
    deps: Record<string, string>;
    pathMappings: Record<string, any>;
    nxJsonPlugins: {
        name: string;
        version: string;
    }[];
    pluginsConfig?: any;
    projectFileMap: ProjectFileMap;
}
export declare const nxProjectGraph: string;
export declare const nxFileMap: string;
export declare function ensureCacheDirectory(): void;
export declare function readProjectFileMapCache(): null | ProjectFileMapCache;
export declare function readProjectGraphCache(): null | ProjectGraph;
export declare function createProjectFileMapCache(nxJson: NxJsonConfiguration<'*' | string[]>, packageJsonDeps: Record<string, string>, projectFileMap: ProjectFileMap, tsConfig: {
    compilerOptions?: {
        paths?: {
            [p: string]: any;
        };
    };
}): ProjectFileMapCache;
export declare function writeCache(cache: ProjectFileMapCache, projectGraph: ProjectGraph): void;
export declare function shouldRecomputeWholeGraph(cache: ProjectFileMapCache, packageJsonDeps: Record<string, string>, projects: ProjectsConfigurations, nxJson: NxJsonConfiguration, tsConfig: {
    compilerOptions: {
        paths: {
            [k: string]: any;
        };
    };
}): boolean;
export declare function extractCachedFileData(fileMap: ProjectFileMap, c: ProjectFileMapCache): {
    filesToProcess: ProjectFileMap;
    cachedFileData: {
        [project: string]: {
            [file: string]: FileData;
        };
    };
};
