/**
 * Builder for adding nodes and dependencies to a {@link ProjectGraph}
 */
import { ProjectFileMap, ProjectGraph, ProjectGraphExternalNode, ProjectGraphProjectNode } from '../config/project-graph';
export declare class ProjectGraphBuilder {
    readonly graph: ProjectGraph;
    private readonly fileMap;
    readonly removedEdges: {
        [source: string]: Set<string>;
    };
    constructor(g?: ProjectGraph, fileMap?: ProjectFileMap);
    /**
     * Merges the nodes and dependencies of p into the built project graph.
     */
    mergeProjectGraph(p: ProjectGraph): void;
    /**
     * Adds a project node to the project graph
     */
    addNode(node: ProjectGraphProjectNode): void;
    /**
     * Removes a node and all of its dependency edges from the graph
     */
    removeNode(name: string): void;
    /**
     * Adds a external node to the project graph
     */
    addExternalNode(node: ProjectGraphExternalNode): void;
    /**
     * Adds static dependency from source project to target project
     */
    addStaticDependency(sourceProjectName: string, targetProjectName: string, sourceProjectFile?: string): void;
    /**
     * Adds dynamic dependency from source project to target project
     */
    addDynamicDependency(sourceProjectName: string, targetProjectName: string, sourceProjectFile: string): void;
    /**
     * Adds implicit dependency from source project to target project
     */
    addImplicitDependency(sourceProjectName: string, targetProjectName: string): void;
    /**
     * Removes a dependency from source project to target project
     */
    removeDependency(sourceProjectName: string, targetProjectName: string): void;
    /**
     * Add an explicit dependency from a file in source project to target project
     * @deprecated this method will be removed in v17. Use {@link addStaticDependency} or {@link addDynamicDependency} instead
     */
    addExplicitDependency(sourceProjectName: string, sourceProjectFile: string, targetProjectName: string): void;
    /**
     * Set version of the project graph
     */
    setVersion(version: string): void;
    getUpdatedProjectGraph(): ProjectGraph;
    private addDependency;
    private removeDependenciesWithNode;
    private calculateTargetDepsFromFiles;
    private calculateAlreadySetTargetDeps;
}
